<?php namespace Visiosoft\ApiGooglecontactsExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Google_Client;
use Google_Service_PeopleService;
use Visiosoft\ApiGooglecontactsExtension\Event\ContactsReceivedEvent;

class ApiGooglecontactsExtension extends Extension
{

    /**
     * This extension provides...
     *
     * This should contain the dot namespace
     * of the addon this extension is for followed
     * by the purpose.variation of the extension.
     *
     * For example anomaly.module.store::gateway.stripe
     *
     * @var null|string
     */
    protected $provides = null;

    public function getContacts()
    {
        $clientID = setting_value('visiosoft.extension.api_googlecontacts::client_id');
        $clientSecret = setting_value('visiosoft.extension.api_googlecontacts::client_secret');
        if (!$clientID || !$clientSecret) {
            throw new \Exception(trans('visiosoft.extension.api_googlecontacts::message.credentials_required'));
        }

        $client = new Google_Client();
        $client->setClientId($clientID);
        $client->setClientSecret($clientSecret);
        $client->setScopes(Google_Service_PeopleService::CONTACTS_READONLY);
        $client->setRedirectUri(url()->route('visiosoft.extension.api_googlecontacts::get_contacts'));
        $client->setAccessType('offline');
        if (request()->get('code') !== null) {
            $client->fetchAccessTokenWithAuthCode(request()->get('code'));
        }
        if (!$client->isAccessTokenExpired()) {
            $service = new Google_Service_PeopleService($client);
            $results = $service->people_connections->listPeopleConnections(
                'people/me',
                ['personFields' => 'names,emailAddresses,phoneNumbers', 'pageSize' => 2000]
            );

            $contactsReceivedEvent = new ContactsReceivedEvent();

            if ($connections = $results->getConnections()) {
                foreach ($connections as $person) {
                    $names = $person->getNames();
                    $emails = $person->getEmailAddresses();
                    $phoneNumbers = $person->getPhoneNumbers();

                    $contactsReceivedEvent->setContact(
                        $names ? $names[0]->getDisplayName() : '',
                        $emails ? $emails[0]->getValue() : '',
                        $phoneNumbers ? $phoneNumbers[0]->getCanonicalForm() : ''
                    );
                }
            }

            event($contactsReceivedEvent);

            return redirect()->to(url()->route('visiosoft.extension.api_googlecontacts::contacts_received'));

        } else {
            return redirect()->to($client->createAuthUrl());
        }
    }


}
