// Handle errors.
let handleError = function (err) {
    console.log("Error: ", err);
};

// Add video streams to the container.
function addVideoStream(elementId) {
    // Creates a new div for every stream
    let streamDiv = document.createElement("div");
    // Assigns the elementId to the div.
    streamDiv.id = elementId;
    // Takes care of the lateral inversion
    streamDiv.style.width = "100%";
    // Adds the div to the container.
    $('.bazaar-other-video-side').html(streamDiv);
};


let client = AgoraRTC.createClient({
    mode: "live",
    codec: "vp8",
});

client.init(agora_options.app_id, function () {
    console.log("client initialized");
}, function (err) {
    console.log("client init failed ", err);
});

client.join(agora_options.token, agora_options.channel, null, (uid) => {
    // Create a local stream
}, handleError);

let localStream = AgoraRTC.createStream({
    audio: true,
    video: true,
});

if (is_owner) {
    $('#join').on('click', function () {
        localStream.init(() => {
            localStream.play("remote-container");
            client.publish(localStream, handleError);
        }, handleError);
        $('#join').remove();
    });
} else {

    // Subscribe to the remote stream when it is published
    client.on("stream-added", function (evt) {
        client.subscribe(evt.stream, handleError);
    });
// Play the remote stream when it is subsribed
    client.on("stream-subscribed", function (evt) {
        let stream = evt.stream;
        let streamId = String(stream.getId());
        addVideoStream(streamId);
        stream.play(streamId);
    });

    $('.bazaar-other-video-side').find('video').muted = false;
}