<?php namespace Visiosoft\AnnouncementPopupExtension;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\BlocksModule\Type\TypeRepository as BlockTypeRepository;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterAnnounceRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterAnnRepeater55EntryModel;


class AnnouncementPopupExtensionSeeder extends Seeder
{
    protected $pages;
    protected $types;
    protected $fields;
    protected $assignments;
    protected $streamRepository;
    protected $areaRepository;
    protected $blockTypes;

    public function __construct(
        PageRepositoryInterface       $pages,
        TypeRepositoryInterface       $types,
        BlockTypeRepository           $blockTypes,
        FieldRepositoryInterface      $fields,
        AssignmentRepositoryInterface $assignments,
        StreamRepositoryInterface     $streamRepository,
        AreaRepository                $areaRepository
    )
    {
        $this->pages = $pages;
        $this->types = $types;
        $this->blockTypes = $blockTypes;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->streamRepository = $streamRepository;
        $this->areaRepository = $areaRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        ###Repeater Seeder
        $repeaters_array = [
            'announce_repeater' => [
                'params' => [
                    'name' => 'Announcement Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'announce_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'title' => [
                        'field_attributes' => [
                            'name' => 'Title',
                            'namespace' => 'repeater',
                            'slug' => 'title',
                            'type' => 'anomaly.field_type.text',
                            'locked' => 0,
                        ],
                        'assignment_attributes' => [
                            'required' => true,
                            'translatable' => true,
                        ]
                    ],
                    'color' => [
                        'field_attributes' => [
                            'name' => 'Color',
                            'namespace' => 'repeater',
                            'slug' => 'color',
                            'type' => 'anomaly.field_type.colorpicker',
                            'locked' => 0,
                        ],
                        'assignment_attributes' => [
                            'required' => true,
                            'translatable' => false,
                        ]
                    ],

                    'only_text' => [
                        'field_attributes' => [
                            'name' => ' Only Text',
                            'namespace' => 'repeater',
                            'slug' => 'only_text',
                            'type' => 'anomaly.field_type.boolean',
                            'locked' => 0,
                        ],
                        'assignment_attributes' => [
                            'required' => false,
                            'translatable' => false,
                        ]
                    ],
                    'end_date' => [
                        'field_attributes' => [
                            'name' => 'End Date',
                            'namespace' => 'repeater',
                            'slug' => 'end_date',
                            'type' => 'anomaly.field_type.datetime',
                            'locked' => 0,
                        ],
                        'assignment_attributes' => [
                            'required' => false,
                            'translatable' => false,
                        ]
                    ],
                    'file' => [
                        'field_attributes' => [
                            'name' => 'File',
                            'namespace' => 'repeater',
                            'slug' => 'file',
                            'type' => 'anomaly.field_type.file',
                            'locked' => 0,
                            'config' => [
                                'folders' => ['images'],
                                "mode" => 'upload',
                            ],
                        ],
                        'assignment_attributes' => [
                            'required' => false,
                            'translatable' => false,
                        ]
                    ],
                ]

            ]
        ];


        foreach ($repeaters_array as $item_repeater) {
            // Create New Repeaters
            if (!$repeater = $this->streamRepository->findBySlugAndNamespace($item_repeater['params']['slug'], 'repeater')) {
                $repeater = $this->streamRepository->create($item_repeater['params']);
            }

            foreach ($item_repeater['fields'] as $field_slug => $field_repeater) {
                if (!$field = $this->fields->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fields->create($field_repeater['field_attributes']);
                }

                if (!$this->assignments->findByStreamAndField($repeater, $field)) {
                    // File Field Assignment
                    $this->assignments->create(
                        array_merge([
                            'stream' => $repeater,
                            'field' => $field,
                        ], $field_repeater['assignment_attributes'])
                    );
                }
            }
        }


        /**
         * Pages Types Seeder
         */

        $page_types = [
            'announcement_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Announcement Popup',
                        'description' => 'This Type For Announcement Popup in Pages',
                    ],
                    'slug' => 'announcement_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => [
                    'editor' => [
                        'params' => [
                            'name' => 'Editor',
                            'namespace' => 'pages',
                            'slug' => 'editor',
                            'type' => 'anomaly.field_type.editor',
                            'locked' => 0,
                        ],
                        'assignment_options' => [
                            'translatable' => true
                        ],
                    ],
                    'announce_page_option' => [
                        'params' => [
                            'name' => 'Announce Page Options',
                            'namespace' => 'pages',
                            'slug' => 'announce_page_option',
                            'type' => 'anomaly.field_type.repeater',
                            'locked' => 0,
                            'config' => [
                                'related' => RepeaterAnnounceRepeaterEntryModel::class
                            ],
                        ],
                        'assignment_options' => [],
                    ],
                ]
            ]
        ];


        foreach ($page_types as $type_slug => $type_options) {
            if (!$type = $this->types->findBySlug($type_slug)) {

                //Create Page Type
                $type = $this->types->create($type_options['content']);

                $page_type_stream = $type->getEntryStream();

                // Create Page Fields
                foreach ($type_options['fields'] as $field_slug => $field_options) {
                    if (!$field = $this->fields->findBySlugAndNamespace($field_slug, 'pages')) {
                        $field = $this->fields->create($field_options['params']);
                    }

                    if (!$this->assignments->findByStreamAndField($page_type_stream, $field)) {
                        $this->assignments->create(array_merge(
                            [
                                'field' => $field,
                                'stream' => $page_type_stream,
                            ],
                            $field_options['assignment_options']
                        ));
                    }
                }
            }
        }

        $pages = [
            'Announcement' => [
                'content' => [
                    'en' => [
                        'title' => 'Announcement Popup',
                    ],
                    'slug' => 'announcement_popup',
                    'enabled' => true,
                    'home' => false,
                ],
                'entry_content' => [
                    'en' => [
                        'editor' =>
                            '
                            <style type="text/css">
                                {{asset_inline("visiosoft.extension.announcement_popup::css/popup.css")}}
                            </style>
                             {% for content in page(pagesFindBySlug(\'announcement-popup\')).entry.announce_page_option %}
                             {% set deadtime = content.end_date.format("Y-m-d H:i") %}
                                <div class="announcement_area" style="background: {{content.color|raw}}">
                                 <input class="d-none" id="end-date" value="{{deadtime}}" />
                                   <div class="ann_wrapper py-2 row">
                                   {% if  content.only_text.value is not empty %}
                                   
                                            <div class="col-md-auto col-12">
                                              <div class="content_section">
                                              
                                                  <div class="ann_text ml-2 my-auto">
                                                      {{content.title|raw}}
                                                  </div>
                                                </div>
                                            </div>
                                            
                                            {% else %}
                                            
                                            <div class="col-md-auto col-12">
                                              <div class="content_section">
                                              {% if(content.file) %}
                                                  <div>
                                                    <img src="{{ file(content.file.path).make.url }}" alt="banner-img" class="ann_icon">
                                                  </div>
                                               {% endif %}
                                         
                                                  <div class="ann_text ml-2 my-auto">
                                                      {{content.title|raw}}
                                                  </div>
                                                </div>
                                            </div>
                                       
                                       <div class="col-md-auto col-12 ml-md-3 mt-2 mt-md-0">
                                               <div class="content_section">
                                            
                                               <div class="ann_counter" id="clockdiv">
                                                   <div class="ann_count_box">
                                                       <span class="days bord">1</span>
                                                   </div>
                                                   <div class="ann_count_box">
                                                       <span class="hours bord">22</span>
                                                   </div>
                                                   <div class="ann_count_box">
                                                       <span class="minutes bord">40</span>
                                                   </div>
                                                   <div class="ann_count_box">
                                                       <span class="seconds bord">45</span>
                                                   </div>
                                               </div>
                                               <a href="#" class="ann_btn">
                                                   Start Use
                                               </a>
                                               
                                           </div>
                                       </div>
                                       
                                       
                                   {% endif %}
                                          <div class="ann_close" id="">
                                           <i class="fa fa-times"></i>
                                       </div>
                                   </div>
                                </div>
                                {% endfor %}
                                <script>
                                {{asset_inline("visiosoft.extension.announcement_popup::js/script.js")}}
                                </script>
                                ',
                    ],
                ],
                'type' => 'announcement_area',
                'children' => []
            ],
        ];
        foreach ($pages as $page) {
            if ($type = $this->types->findBySlug($page['type'])) {
                    $selected_type = [];
                    foreach ($page['entry_content'] as $content) {
                        $selected_type = [
                            'type' => $type,
                            'entry' => $type->getEntryModel()->newQuery()->create($content)
                        ];
                    }
                    $new_page = array_merge($page['content'], $selected_type);
                    $mainPage = $this->pages->create($new_page)->getQueueableId();

                    if ($page['children']) {
                        foreach ($page['children'] as $child) {
                            $type = $this->types->findBySlug($child['type']);
                            $selected_type = [];
                            foreach ($child['entry_content'] as $content) {
                                $selected_type = [
                                    'type' => $type,
                                    'entry' => $type->getEntryModel()->newQuery()->create($content),
                                    'parent_id' => $mainPage,
                                ];
                            }
                            $new_page = array_merge($child['content'], $selected_type);
                            $this->pages->create($new_page);
                        }
                    }
            }
        }
    }
}
