$( document ).ready(function() {
    function getTimeRemaining(endtime) {
        var t = Date.parse(endtime) - Date.parse(new Date());
        if (t<0) { return false; }
        var seconds = Math.floor((t / 1000) % 60);
        var minutes = Math.floor((t / 1000 / 60) % 60);
        var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
        var days = Math.floor(t / (1000 * 60 * 60 * 24));
        return {
            'total': t,
            'days': days,
            'hours': hours,
            'minutes': minutes,
            'seconds': seconds
        };
    }
    function initializeClock(id, endtime) {
        function updateClock() {
            var t = getTimeRemaining(endtime);
            if (t) {
                $('.ann_count_box .days').text(t.days) ;
                $('.ann_count_box .hours').text(('0' + t.hours).slice(-2)) ;
                $('.ann_count_box .minutes').text(('0' + t.minutes).slice(-2)) ;
                $('.ann_count_box .seconds').text(('0' + t.seconds).slice(-2)) ;
            } else {
                clearInterval(timeinterval);
            }
        }
        updateClock();
        var timeinterval = setInterval(updateClock, 1000);
    }
    var deadtime = $('#end-date').val();
    deadline = new Date(deadtime);

    initializeClock('clockdiv', deadline);
});


$(document).on('click', '.ann_close', function () {
    $('.announcement_area').html('').addClass('d-none');
})