<?php namespace Visiosoft\AlibabaTheme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\AlibabaTheme\Handler\GetBuyingLeads;
use Visiosoft\AlibabaTheme\Handler\GetMainAndSubCats;

class AlibabaThemePlugin extends Plugin
{

	/**
	 * @return array
	 */
	public function getFunctions()
	{
		return [
			new \Twig_SimpleFunction(
				'getBuyingLeads',
				function ($column, $value, $paginate) {
					return $this->dispatch(new GetBuyingLeads($column, $value, $paginate));
				}
			),
			new \Twig_SimpleFunction(
				'getMainAndSubCats',
				function () {
					return $this->dispatch(new GetMainAndSubCats());
				}
			)

		];
	}

}
