<?php namespace Visiosoft\AlibabaTheme\Handler;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\Http\Controller\CustomFieldsController;

class GetBuyingLeads
{
	protected $column, $value, $paginate;

	public function __construct($column, $value, $paginate)
	{
		$this->column = $column;
		$this->value = $value;
		$this->paginate = $paginate;
	}

	public function handle(AdvRepositoryInterface $ads)
	{
		$advModel = new AdvModel();

		$ads = $ads->searchAdvs('list', [], [], null, null, null, false);
		$cf = app(CustomFieldsController::class)->whereJsonContains($ads, $this->column, $this->value, $this->paginate);
		$cf = $advModel->getLocationNames($cf);

		foreach ($cf as $index => $ad) {
			$cf[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
			$cf[$index] = $advModel->AddAdsDefaultCoverImage($ad);
		}
		return $cf;
    }
}
