<?php

use Anomaly\MultipleFieldType\MultipleFieldType;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CatsModule\Category\CategoryModel;

return [
    "site_logo" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ["images"],
            "mode" => "upload",
        ]
    ],
    "homepage_category" => [
        'required' => true,
        'type' => 'anomaly.field_type.select',
        'config' => [
            'handler' => 'Visiosoft\AlibabaTheme\SettingHandler\CategoriesOptions@getOptionsBySelect'
        ],
    ],
    "banner_img" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ["images"],
        ]
    ],
    "banner_link" => [
        "type" => "anomaly.field_type.url",
        "config" => [
            "default_value" => '#',
        ]
    ],
    "banner_bg" => [
        "type" => "anomaly.field_type.colorpicker",
    ],
    "nav_primary_color" => [
        "type" => "anomaly.field_type.colorpicker",
        'config' => [
            'default_value' => '#2357c5'
        ],
    ],
	"choices_tabs_categories" => [
		'required' => true,
		'type' => 'anomaly.field_type.checkboxes',
		'config' => [
			'handler' => 'Visiosoft\AlibabaTheme\SettingHandler\CategoriesOptions@getOptionsByCheckboxes'
		],
	],
	"regional_country" => [
		'type' => 'anomaly.field_type.checkboxes',
		'config' => [
			'handler' => 'Visiosoft\AlibabaTheme\SettingHandler\CountriesOptions@handle',
			'mode' => 'tags',
			'max' => 6,
		]
	],
	"is_buying_selling_title" => [
		'type' => 'anomaly.field_type.relationship',
		"config" => [
			"related" => \Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel::class
		]
	],
	"is_buying_value" => [
		"type" => "anomaly.field_type.select"
	],
	"is_selling_value" => [
		"type" => "anomaly.field_type.select"
	],
	"ads_banner_area" => [
		"type" => "anomaly.field_type.wysiwyg"
	]
];
