<?php namespace Visiosoft\AlibabaTheme;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class AlibabaThemeSeeder extends Seeder
{

    private $fieldRepository;
    private $streamRepository;
    private $assignmentRepository;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository,
        AssignmentRepositoryInterface $assignmentRepository
    )
    {
        parent::__construct();
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->assignmentRepository = $assignmentRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $imageField = $this->fieldRepository->findBySlugAndNamespace('carousel_images', 'pages');
        $defaultPagesStream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');
        if ($imageField) {
            $imageField->delete();
        }
        $imagesField = $this->fieldRepository->create([
            'name' => 'Carousel Images',
            'namespace' => 'pages',
            'slug' => 'carousel_images',
            'type' => 'anomaly.field_type.files',
            'locked' => 0,
            "config" => [
                "folders" => ['images'],
            ]
        ]);
        $this->assignmentRepository->create([
            'stream_id' => $defaultPagesStream->getId(),
            'field_id' => $imagesField->id,
            'label' => 'Carousel Images',
        ]);
    }
}