$( document ).ready(function() {
    // Sidenav script
    $('#mainNavbarSideButton').on('click', function() {
        $('#mainNavbarSide').addClass('reveal');
        $('.overlay').show();
    });
    $('.overlay').on('click', function(){
        $('#mainNavbarSide').removeClass('reveal');
        $('.overlay').hide();
    });

    // Change search mode script
    $('.search-type').on('change', function () {
        $('#home-page-search-form').attr('action', this.value)
    });

    // Change ads list styles
    $('.list-classified>.text-dark>.row .col-md-2').removeClass('col-md-2').addClass('col-md-4');
    $('.list-classified>.text-dark>.row .col-md-7').removeClass('col-md-7').addClass('col-md-5');

    // Carousel
    $('.carousel').carousel({
        interval: 5000
    })

    var swiper = new Swiper('.recommendations-swiper-container', {
        // loop: true,
        breakpoints: {
            0: {
                slidesPerView: 3,
                spaceBetween: 5,
            },
            480: {
                slidesPerView: 5,
                spaceBetween: 5,
            },
            640: {
                slidesPerView: 7,
                spaceBetween: 5,
            },
            1200: {
                slidesPerView: 9,
                spaceBetween: 5,
            }
        },
        slidesPerColumn: 2,
        slidesPerColumnFill: 'row',
        slidesPerGroup: 10,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
    });

    var buyingSwiper = new Swiper('.ads-leads-swiper-container' , {
        breakpoints: {
            0: {
                slidesPerView: 3,
                spaceBetween: 5,
            },
            640: {
                slidesPerView: 4,
                spaceBetween: 5,
            },
            1200: {
                slidesPerView: 5,
                spaceBetween: 5,
            }
        },
        slidesPerView: 5,
        spaceBetween: 5,
        slidesPerColumn: 1,
        slidesPerColumnFill: 'column',
        slidesPerGroup: 5,
        pagination: {
            el: '.ads-leads-swiper-pagination',
            clickable: true,
        }
    });

    var yourChoicesSwiper = new Swiper('.your-choices-tab', {
        init: true,
        slidesPerView: 1.2,
        slidesPerGroup: 1,
        spaceBetween: 20,
        observer: true,
        observeParents: true,
        breakpoints: {
            576: {
                slidesPerView: 2.2,
                slidesPerGroup: 2,
            },
            768: {
                slidesPerView: 3.2,
                slidesPerGroup: 3,
            },
            1200: {
                slidesPerView: 3.2,
                slidesPerGroup: 4,
            },
        }
    });

    $('.category-list a').click(function () { // Show category's related products
        const clickedItem = $(this)
        if (!clickedItem.hasClass('active')) {
            let categoryId = clickedItem.attr('id')
            if (typeof categoryId !== 'undefined' && categoryId !== false) {
                categoryId = categoryId.substring(3)
                $.ajax({
                    type: 'get',
                    url: '/ajax/get-advs-by-category/'+ categoryId,
                    success: function (response) {
                        response.forEach(function (adv, index) {
                            const tabPaneID = clickedItem.attr('aria-controls')
                            $(`#${tabPaneID} > .your-choices-slider`).append(`
                            <a href="${adv.detail_url}" class="link-unstyled swiper-slide deal-slider-item">
                                <div class="deal-img"
                                style="background-image: url('${adv.cover_photo}')"></div>
                                <p class="deal-name">${adv.name}</p>
                                <p class="deal-price">${adv.currency_price ?? ''}</p>
                            </a>
                        `)
                        })
                        clickedItem.removeAttr('id')
                    }
                })
            }
        }
    })
});
