<?php namespace Visiosoft\AlibabaTheme\SettingHandler;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\LocationModule\Country\CountryRepository;

class CountriesOptions
{
    private $countryRepository;

    public function __construct(CountryRepository $countryRepository)
    {
        $this->countryRepository = $countryRepository;
    }

    public function handle(CheckboxesFieldType $fieldType)
    {
        $countries = $this->countryRepository->newQuery()->get();
        $options = array();
        foreach ($countries as $country) {
            $options[$country->abv] = $country->name;
        }
        $fieldType->setOptions($options);
    }
}