<?php namespace Visiosoft\AlibabaTheme\Handler;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueModel;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class getBuyingLeads
{
    protected $status, $per_page;

    public function __construct($status, $per_page)
    {
        $this->status = $status;
        $this->per_page = $per_page;
    }

    public function handle(CustomFieldRepositoryInterface $customFieldRepository, CfvalueModel $cfvalueModel)
    {
    	$status = $this->status;
	    $advModel = new AdvModel();

	    $customfields = $customFieldRepository->findBySlug('is_buying');
	    $cfvalue = $cfvalueModel->where('custom_field_id', $customfields->id)->first();

	    $latest_advs = AdvModel::query()
		    ->whereDate('finish_at', '>=', date("Y-m-d H:i:s"))
		    ->where('status', '=', 'approved')
		    ->where('slug', '!=', '')
		    ->where(function ($query) use ($status, $customfields, $cfvalue) {
			    if ($status != null and $cfvalue->custom_field_value == 'Yes') {
				    $query->whereRaw('JSON_CONTAINS(cf_json, \'"' . $cfvalue->id . '"\', \'$.cf' . $customfields->id . '\')');
			    }
		    })
		    ->orderBy('publish_at', 'desc')
		    ->paginate($this->per_page);

	    $ads = $advModel->getLocationNames($latest_advs);
	    foreach ($ads as $index => $ad) {
		    $ads[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
		    $ads[$index] = $advModel->AddAdsDefaultCoverImage($ad);
	    }
	    return $ads;

    }
}
