$('.alibaba-cart-button').on('click', function () {
    var quantity = $('input[name="quantity"]').val();
    var id = $('input[name="quantity"]').attr('data-id');
    var name = $('select[name="option"]').val();
    var configuration = $('select[name="configuration"]').val();
    name = name ? name : null;
    return addCart(id, quantity, name, configuration)
})

function addCart(id, quantity, name = null, configuration = null) {
    let data, url;

    if (configuration) {
        data = 'quantity=' + quantity + '&configuration=' + configuration
        url = api_add_conf_cart
    } else {
        data = 'id=' + id + '&quantity=' + quantity;
        data = name ? data + '&name=' + name : data;
        url = adv_add_cart_ajax
    }

    $.ajax({
        type: 'POST',
        url: url,
        data: data,
        success: function (data) {
            if (data.status == "success") {
                Swal.fire({
                    icon: 'success',
                    title: successMessage,
                    showConfirmButton: false,
                    timer: 1500
                })
                $('.carts a .badge').html(data.count)
            } else if (data.status == "guest") {
                window.location.href = "/login?redirect=" + window.location.href;
            } else {
                alert(data.msg);
            }
        }
    });
}