<?php namespace Visiosoft\AlibabaTheme;
use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\HtmlBlock\HtmlBlockBlocksEntryModel;
use Anomaly\Streams\Platform\Model\HtmlBlock\HtmlBlockBlocksEntryTranslationsModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
class AlibabaThemeSeeder extends Seeder
{
	private $fieldRepository;
	private $streamRepository;
	private $assignmentRepository;
	private $settingRepository;
	private $blockRepository;
	private $blocksTypeRepository;
	private $areaRepository;
	private $htmlBlocks;
	private $htmlBlocksTranslation;
	private $typesEntryModel;
	private $customFieldRepository;
	private $cfvalueRepository;
	public function __construct(
		FieldRepositoryInterface $fieldRepository,
		StreamRepositoryInterface $streamRepository,
		AssignmentRepositoryInterface $assignmentRepository,
		SettingRepositoryInterface $settingRepository,
		TypeRepositoryInterface $blocksTypeRepository,
		BlockRepositoryInterface $blockRepository,
		AreaRepository $areaRepository,
		HtmlBlockBlocksEntryModel $htmlBlocks,
		HtmlBlockBlocksEntryTranslationsModel $htmlBlocksTranslation,
		\Anomaly\PostsModule\Type\Contract\TypeRepositoryInterface $typesEntryModel,
		CustomFieldRepositoryInterface $customFieldRepository,
		CfvalueRepositoryInterface $cfvalueRepository
	)
	{
		parent::__construct();
		$this->fieldRepository = $fieldRepository;
		$this->streamRepository = $streamRepository;
		$this->assignmentRepository = $assignmentRepository;
		$this->settingRepository = $settingRepository;
		$this->blocksTypeRepository = $blocksTypeRepository;
		$this->blockRepository = $blockRepository;
		$this->areaRepository = $areaRepository;
		$this->htmlBlocks = $htmlBlocks;
		$this->htmlBlocksTranslation = $htmlBlocksTranslation;
		$this->typesEntryModel = $typesEntryModel;
		$this->customFieldRepository = $customFieldRepository;
		$this->cfvalueRepository = $cfvalueRepository;
	}
	/**
	 * Run the seeder.
	 */
	public function run()
	{
		$imageField = $this->fieldRepository->findBySlugAndNamespace('carousel_images', 'pages');
		$defaultPagesStream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');
		if (!$imageField) {
			$imagesField = $this->fieldRepository->create([
				'name' => 'Carousel Images',
				'namespace' => 'pages',
				'slug' => 'carousel_images',
				'type' => 'anomaly.field_type.files',
				'locked' => 0,
				"config" => [
					"folders" => ['images'],
				]
			]);
			$this->assignmentRepository->create([
				'stream_id' => $defaultPagesStream->getId(),
				'field_id' => $imagesField->id,
				'label' => 'Carousel Images',
			]);
		}

		//Blocks Seeder
		if (!$this->areaRepository->findBySlug('our-choices')) {
			$this->areaRepository->create([
				'en' => [
					'name' => 'Our Choices'
				],
			]);

			$this->blocksTypeRepository->create([
				'name' => 'Our Choices',
				'slug' => 'our_choices',
			]);

			$typesStream = $this->streamRepository->findBySlugAndNamespace('our_choices_blocks', 'blocks');

			$blockFields = [
				[
					'name' => 'Image',
					'slug' => 'image',
					'namespace' => 'blocks',
					'translatable' => false,
					'type' => 'anomaly.field_type.file',
					'config' => [
						'required' => true,
						'folders' => ['images'],
					],
				], [
					'name' => 'Choice Category',
					'slug' => 'choice_category',
					'namespace' => 'blocks',
					'translatable' => false,
					'type' => 'anomaly.field_type.relationship',
					'config' => [
						'related' => CategoryModel::class,
						'required' => true,
					],
				],
			];

			foreach ($blockFields as $blockField) {
				$field = $this->fieldRepository->findBySlugAndNamespace($blockField['slug'], 'blocks');
				if (!$field) {
					$field = $this->fieldRepository->create([
						'name' => $blockField['name'],
						'namespace' => $blockField['namespace'],
						'slug' => $blockField['slug'],
						'type' => $blockField['type'],
						'locked' => 0,
						'config' => $blockField['config'],
					]);
				}

				$assign = $this->assignmentRepository->findByStreamAndField($typesStream, $field);
				if (!$assign){
					$this->assignmentRepository->create([
						'stream_id' => $typesStream->getId(),
						'field_id' => $field->id,
						'translatable' => $blockField['translatable'],
					]);
				}
			}
		}
		// POSTS Seed
		if (!$this->typesEntryModel->findBySlug('community')) {
			$this->typesEntryModel->create([
				'name' => 'Community',
				'slug' => 'community',
			]);
		}
		if (!$this->customFieldRepository->findBySlug('is_buying')) {
			$customfield = $this->customFieldRepository->create([
				'slug' => 'is_buying',
				'type' => 'select',
				'required' => true,
				'en' => [
					'name' => 'Is Buying'
				]
			]);
			$this->cfvalueRepository->create([
				'custom_field_id' => $customfield->id,
				'en' => [
					'custom_field_value' => 'Yes'
				]
			]);
			$this->cfvalueRepository->create([
				'custom_field_id' => $customfield->id,
				'en' => [
					'custom_field_value' => 'No'
				]
			]);
		}
		// Activate
		$this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.alibaba');
		// Seeder
		Model::unguard();
		DB::unprepared(file_get_contents(__DIR__ . '/alibaba_demodata.sql'));
		Model::reguard();
		$zip = new \ZipArchive();
		$zip->open(__DIR__ . '/images.zip', \ZipArchive::CREATE);
		$zip->extractTo(storage_path('streams/default/files-module/local/'));
		$zip->close();
		Artisan::call('assets:clear');
	}
}