<?php namespace Visiosoft\AlibabaTheme;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Support\Facades\Artisan;

class AlibabaThemeSeeder extends Seeder
{

    private $fieldRepository;
    private $streamRepository;
    private $assignmentRepository;
    private $settingRepository;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        SettingRepositoryInterface $settingRepository
    )
    {
        parent::__construct();
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->settingRepository = $settingRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $imageField = $this->fieldRepository->findBySlugAndNamespace('carousel_images', 'pages');
        $defaultPagesStream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');
        if ($imageField) {
            $imageField->delete();
        }
        $imagesField = $this->fieldRepository->create([
            'name' => 'Carousel Images',
            'namespace' => 'pages',
            'slug' => 'carousel_images',
            'type' => 'anomaly.field_type.files',
            'locked' => 0,
            "config" => [
                "folders" => ['images'],
            ]
        ]);
        $this->assignmentRepository->create([
            'stream_id' => $defaultPagesStream->getId(),
            'field_id' => $imagesField->id,
            'label' => 'Carousel Images',
        ]);

        // Activate
        $this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.alibaba');
        Artisan::call('assets:clear');
    }
}