<?php namespace Visiosoft\AlibabaTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\HtmlBlock\HtmlBlockBlocksEntryModel;
use Anomaly\Streams\Platform\Model\HtmlBlock\HtmlBlockBlocksEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Posts\PostsTypesEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Support\Facades\Artisan;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class AlibabaThemeSeeder extends Seeder
{

    private $fieldRepository;
    private $streamRepository;
    private $assignmentRepository;
    private $settingRepository;
    private $blockRepository;
    private $blocksTypeRepository;
    private $areaRepository;
    private $htmlBlocks;
    private $htmlBlocksTranslation;
    private $typesEntryModel;
    private $customFieldRepository;
    private $cfvalueRepository;

    public function __construct(
	    FieldRepositoryInterface $fieldRepository,
	    StreamRepositoryInterface $streamRepository,
	    AssignmentRepositoryInterface $assignmentRepository,
	    SettingRepositoryInterface $settingRepository,
	    TypeRepositoryInterface $blocksTypeRepository,
	    BlockRepositoryInterface $blockRepository,
	    AreaRepository $areaRepository,
	    HtmlBlockBlocksEntryModel $htmlBlocks,
	    HtmlBlockBlocksEntryTranslationsModel $htmlBlocksTranslation,
	    PostsTypesEntryModel $typesEntryModel,
	    CustomFieldRepositoryInterface $customFieldRepository,
	    CfvalueRepositoryInterface $cfvalueRepository
    )
    {
        parent::__construct();
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->settingRepository = $settingRepository;
	    $this->blocksTypeRepository = $blocksTypeRepository;
	    $this->blockRepository = $blockRepository;
	    $this->areaRepository = $areaRepository;
	    $this->htmlBlocks = $htmlBlocks;
	    $this->htmlBlocksTranslation = $htmlBlocksTranslation;
	    $this->typesEntryModel = $typesEntryModel;
	    $this->customFieldRepository = $customFieldRepository;
	    $this->cfvalueRepository = $cfvalueRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $imageField = $this->fieldRepository->findBySlugAndNamespace('carousel_images', 'pages');
        $defaultPagesStream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');
        if ($imageField) {
            $imageField->delete();
        }
        $imagesField = $this->fieldRepository->create([
            'name' => 'Carousel Images',
            'namespace' => 'pages',
            'slug' => 'carousel_images',
            'type' => 'anomaly.field_type.files',
            'locked' => 0,
            "config" => [
                "folders" => ['images'],
            ]
        ]);
        $this->assignmentRepository->create([
            'stream_id' => $defaultPagesStream->getId(),
            'field_id' => $imagesField->id,
            'label' => 'Carousel Images',
        ]);

        if ($area = $this->areaRepository->getModel()->where('slug', 'our-choices')->first()){
			$area->forceDelete();
        }

        $area = $this->areaRepository->create([
        	'name' => 'Our Choices',
	        'slug' => 'our-choices',
        ]);

        $htmlBlocks = $this->htmlBlocks->create([
        	'en' => [
        		'html' => '<section class="your-choices-container pt-5 bg-white border-top border-primary">
				    <div class="cover-frame">
				        <div class="your-choices-wrapper d-flex flex-column flex-lg-row">
				
				            <div class="nav flex-nowrap category-list px-4 pr-lg-3 pl-lg-0 d-flex d-lg-block pt-lg-3"
				                 role="tablist" aria-orientation="vertical">
				                <div class="cover-content-title px-4 mb-3">
				                    <h5 class="mb-0">{{ trans(\'visiosoft.theme.gg::field.our_choices_for_you\') }}</h5>
				                </div>
				                {% for category in setting_value(\'visiosoft.theme.gg::choices_tabs_categories\') %}
				                    {% set categoryEntry = entries(\'cats\', \'category\').find(category) %}
				                    <a class="d-flex link-unstyled{{ loop.first ? \' active\' }}" data-toggle="pill"
				                       href="#v-pills-{{ categoryEntry.slug }}" role="tab" aria-selected="true"
				                        {{ not loop.first ? \'id=tab\' ~ category }}
				                       aria-controls="v-pills-{{ categoryEntry.slug }}">
				                        <span class="category-border d-none d-lg-block"></span>
				                        <p class="text-truncate flex-fill mb-0">{{ categoryEntry.name }}</p>
				                    </a>
				                {% endfor %}
				            </div>
				            <div class="your-choices-tabs tab-content">
				                {% for category in setting_value(\'visiosoft.theme.gg::choices_tabs_categories\') %}
				                    {% set categoryEntry = entries(\'cats\', \'category\').find(category) %}
				                    <div class="row align-items-center px-4 your-choices-tab tab-pane{{ loop.first ? \' active\' }}"
				                         id="v-pills-{{ categoryEntry.slug }}" role="tabpanel"
				                         aria-labelledby="v-pills-{{ categoryEntry.slug }}-tab">
				                        {% if loop.first %}
				                            <div class="d-flex">
				                                <div class="col-6 px-1 d-flex flex-column align-items-center pt-auto border-right">
				                                    <img class="w-100" src="https://image.ec21.com/optimg/recommend/bg_bicycle.jpg"
				                                         alt="">
				                                </div>
				                                <div class="col-2 px-1 d-flex border-right">
				                                    <div class="mt-auto align-items-center text-center">
				                                        <a href="#">Boat</a>
				                                        <img class="w-100 mt-5" src="https://image.ec21.com/optimg/recommend/boat.jpg"
				                                             alt="">
				                                    </div>
				                                </div>
				                                <div class="col-2 px-1 d-flex border-right">
				                                    <div class="mt-auto align-items-center text-center">
				                                        <a href="#">Boat</a>
				                                        <img class="w-100 mt-5"
				                                             src="https://image.ec21.com/optimg/recommend/golf_carts.jpg" alt="">
				                                    </div>
				                                </div>
				                                <div class="col-2 px-1 d-flex">
				                                    <div class="mt-auto align-items-center text-center">
				                                        <a href="#">Boat</a>
				                                        <img class="w-100 mt-5"
				                                             src="https://image.ec21.com/optimg/recommend/trailer.jpg" alt="">
				                                    </div>
				                                </div>
				                            </div>
				                        {% endif %}
				                    </div>
				                {% endfor %}
				            </div>
				        </div>
				    </div>
				</section>'
	        ]
        ]);

	    $blocks = $this->blockRepository->create([
		    'area_id' => $area->id,
		    'area_type' => 'Anomaly\BlocksModule\Area\AreaModel',
		    'field_id' => 77,
		    'extension' => 'anomaly.extension.html_block',
		    'entry_id' => $htmlBlocks->id,
		    'entry_type' => 'Anomaly\HtmlBlockExtension\Block\BlockModel',
		    'display_title' => 0,
	    ]);

	    // POSTS Seed
/*	    $this->typesEntryModel->create([
	    	'name' => 'Community',
		    'slug' => 'community',
	    ]);*/

	    $customfield = $this->customFieldRepository->create([
	    	'slug' => 'is_buying',
		    'type' => 'select',
		    'en' => [
		    	'name' => 'Is Buying'
		    ]
	    ]);

	    $this->cfvalueRepository->create([
	    	'custom_field_id' => $customfield->id,
		    'en' => [
		    	'custom_field_value' => 'Yes'
		    ]
	    ]);

	    $this->cfvalueRepository->create([
	    	'custom_field_id' => $customfield->id,
		    'en' => [
		    	'custom_field_value' => 'No'
		    ]
	    ]);

        // Activate
        $this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.alibaba');
        Artisan::call('assets:clear');
    }
}