$( document ).ready(function() {
    // Sidenav script
    $('#mainNavbarSideButton').on('click', function() {
        $('#mainNavbarSide').addClass('reveal');
        $('.overlay').show();
    });
    $('.overlay').on('click', function(){
        $('#mainNavbarSide').removeClass('reveal');
        $('.overlay').hide();
    });

    // Change search mode script
    $('.search-type').on('change', function () {
        $('#home-page-search-form').attr('action', this.value)
    });

    // Change ads list styles
    $('.list-classified>.text-dark>.row .col-md-2').removeClass('col-md-2').addClass('col-md-4');
    $('.list-classified>.text-dark>.row .col-md-7').removeClass('col-md-7').addClass('col-md-5');

    // Carousel
    $('.carousel').carousel({
        interval: 5000
    })

    var swiper = new Swiper('.swiper-container', {
        // loop: true,
        breakpoints: {
            0: {
                slidesPerView: 3,
                spaceBetween: 5,
            },
            480: {
                slidesPerView: 5,
                spaceBetween: 5,
            },
            640: {
                slidesPerView: 7,
                spaceBetween: 5,
            },
            1200: {
                slidesPerView: 9,
                spaceBetween: 5,
            }
        },
        slidesPerColumn: 2,
        slidesPerColumnFill: 'row',
        slidesPerGroup: 10,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
    });

    var buyingSwiper = new Swiper('.ads-leads-swiper-container' , {
        breakpoints: {
            0: {
                slidesPerView: 3,
                spaceBetween: 5,
            },
            640: {
                slidesPerView: 4,
                spaceBetween: 5,
            },
            1200: {
                slidesPerView: 5,
                spaceBetween: 5,
            }
        },
        slidesPerView: 5,
        spaceBetween: 5,
        slidesPerColumn: 1,
        slidesPerColumnFill: 'column',
        slidesPerGroup: 5,
        pagination: {
            el: '.ads-leads-swiper-pagination',
            clickable: true,
        }
    });

    var yourChoicesSwiper = new Swiper('.your-choices-tab', {
        init: true,
        slidesPerView: 1.2,
        slidesPerGroup: 1,
        spaceBetween: 20,
        observer: true,
        observeParents: true,
        navigation: {
            nextEl: '.your-choices-tab .gg-slider-button-next',
            prevEl: '.your-choices-tab .gg-slider-button-prev',
        },
        breakpoints: {
            576: {
                slidesPerView: 2.2,
                slidesPerGroup: 2,
            },
            768: {
                slidesPerView: 3.2,
                slidesPerGroup: 3,
            },
            1200: {
                slidesPerView: 4.2,
                slidesPerGroup: 4,
            },
        }
    });

});