<?php namespace Visiosoft\AdvBarWidgetExtension;

use Anomaly\DashboardModule\Dashboard\Contract\DashboardRepositoryInterface;
use Anomaly\DashboardModule\Widget\Contract\WidgetRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Dashboard\DashboardWidgetsEntryTranslationsModel;

class AdvBarWidgetExtensionSeeder extends Seeder
{
    /**
     * Run the seeder.
     */
    public function run(
        WidgetRepositoryInterface $widgetRepository,
        DashboardRepositoryInterface $dashboardRepository,
        DashboardWidgetsEntryTranslationsModel $widgetsEntryTranslationsModel
    )
    {
        $advBarWidget = $widgetRepository->findBy('extension', 'visiosoft.extension.adv_bar_widget');
        if ($advBarWidget) {
            $widgetsEntryTranslationsModel->newQuery()->where('entry_id', $advBarWidget->id)->delete();
            $advBarWidget->forceDelete();
        }

        $dashboard = $dashboardRepository->findBy('slug', 'welcome');
        if (is_null($dashboard)) {
            $dashboard = $dashboardRepository->create([
                'name' => 'Welcome',
                'slug' => 'welcome',
                'description' => 'This is the default dashboard.',
                'layout'      => '24'
            ]);
        }

        $widgetRepository->create([
            'title' => 'Adv charts',
            'extension'   => 'visiosoft.extension.adv_bar_widget',
            'dashboard'   => $dashboard->id,
            'pinned'   => true,
        ]);
    }
}
