<?php namespace Visiosoft\AdvBarWidgetExtension\Command;

use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\AdvsModule\Adv\AdvModel;


class LoadItems
{

    use DispatchesJobs;

    protected $widget;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
    }
    public function handle()
    {
        $barChartData = $this->barChart();
        $pieChartData = $this->pieChart();
        $this->widget->addData('pie_chart', $pieChartData);
        $this->widget->addData('bar_chart', $barChartData);
    }

    public function barChart()
    {
        $lastYear = date('Y-m-d', time() - 31536000 / 2);
        $startDate = (new \DateTime($lastYear))->modify('first day of this month');
        $startDate = $startDate->format('Y-m-d');
        $months = $this->getMonthListFromDate($startDate);
        $colors = [
            'approved' => [
                'color' => '#7361E4',
                'name' => trans('visiosoft.extension.adv_bar_widget::field.approved_ads')
            ],
            'pending_user' => [
                'color' => '#2AB1E0',
                'name' => trans('visiosoft.extension.adv_bar_widget::field.pending_ads')
            ],
            'declined' => [
                'color' => '#FFA940',
                'name' => trans('visiosoft.extension.adv_bar_widget::field.outdated_ads')
            ],
            'passive' => [
                'color' => '#D81B21',
                'name' => trans('visiosoft.extension.adv_bar_widget::field.passive_ads')
            ]
        ];
        $ads = AdvModel::where('created_at', '>', $lastYear)
            ->whereNull('deleted_at')
            ->orderBy('created_at', 'asc')->get();
        $results = [];
        $data = [];
        if (!empty($ads)) {
            $ads = $ads->groupBy('status')->toArray();
            foreach ($ads as $status => $items) {
                foreach ($items as $ad) {
                    $results[$status][strtotime(date('F Y', strtotime($ad['created_at'])))][] = $ad['id'];
                }
            }
        }
        if (!empty($results)) {
            foreach ($results as $status => $items) {
                $monthlyData = [];
                foreach ($months as $timestamp => $month) {
                    $monthlyData[$month] = 0;
                    if (!empty($items[$timestamp])) {
                        $monthlyData[$month] = count($items[$timestamp]);
                    }
                }
                $data[$status]['name'] = $status;
                $data[$status]['data'] = array_values($monthlyData);
                if (!empty($colors[$status])) {
                    $data[$status]['name'] = $colors[$status]['name'];
                    $data[$status]['color'] = $colors[$status]['color'];
                }
            }
        }
        $data = json_encode(array_values($data));
        $categories = json_encode(array_values($months));
        return ['series' => $data, 'categories' => $categories];
    }

    public function pieChart()
    {
        $myAdvs = new AdvModel();

        $myAdvsApprove = $myAdvs
            ->getAdv()
            ->where('advs_advs.status', 'approved')
            ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'));
        $myAdvsApprove = count($myAdvsApprove->get());

        $myAdvsPending = $myAdvs
            ->getAdv()
            ->where('advs_advs.status', 'pending_admin')
            ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'))
            ->orWhereNull('advs_advs.finish_at');
        $myAdvsPending = count($myAdvsPending->get());

        $myAdvsOutdated = $myAdvs
            ->getAdv()
            ->where('advs_advs.finish_at', '<', date('Y-m-d H:i:s'))
            ->WhereNotNull('advs_advs.finish_at');
        $myAdvsOutdated = count($myAdvsOutdated->get());

        $myAdvsPassive = $myAdvs
            ->getAdv()
            ->where('advs_advs.status', 'passive');
        $myAdvsPassive = count($myAdvsPassive->get());
        $total = $myAdvsApprove + $myAdvsPending + $myAdvsOutdated + $myAdvsPassive;
        $myAdvsApprovePercent = 0;
        $myAdvsPendingPercent = 0;
        $myAdvsOutdatedPercent = 0;
        $myAdvsPassivePercent = 0;
        if ($total > 0) {
            $myAdvsApprovePercent = round(($myAdvsApprove / $total), 2);
            $myAdvsPendingPercent = round(($myAdvsPending / $total), 2);
            $myAdvsOutdatedPercent = round(($myAdvsOutdated / $total), 2);
            $myAdvsPassivePercent = round(($myAdvsPassive / $total), 2);
        }
        return [
            'approve' => $myAdvsApprovePercent,
            'pending' => $myAdvsPendingPercent,
            'outdated' => $myAdvsOutdatedPercent,
            'passive' => $myAdvsPassivePercent
        ];
    }

    protected function getMonthListFromDate($date)
    {
        $start = new \DateTime($date);
        $end = new \DateTime();
        $interval = \DateInterval::createFromDateString('1 month');
        $period = new \DatePeriod($start, $interval, $end);
        $months = [];
        foreach ($period as $dt) {
            $months[$dt->getTimestamp()] = $dt->format("M Y");
        }
        return $months;
    }
}
