<?php namespace Visiosoft\AdsWidgetExtension;

use Anomaly\DashboardModule\Dashboard\Contract\DashboardRepositoryInterface;
use Anomaly\DashboardModule\Widget\Contract\WidgetRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Dashboard\DashboardWidgetsEntryTranslationsModel;

class AdsWidgetExtensionSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(
        WidgetRepositoryInterface $widgetRepository,
        DashboardRepositoryInterface $dashboardRepository,
        DashboardWidgetsEntryTranslationsModel $widgetsEntryTranslationsModel
    )
    {
        $adsWidget = $widgetRepository->findBy('extension', 'visiosoft.extension.ads_widget');
        if ($adsWidget) {
            $widgetsEntryTranslationsModel->newQuery()->where('entry_id', $adsWidget->id)->delete();
            $adsWidget->forceDelete();
        }

        $dashboard = $dashboardRepository->findBy('slug', 'welcome');
        if (is_null($dashboard)) {
            $dashboard = $dashboardRepository->create([
                'name' => 'Welcome',
                'slug' => 'welcome',
                'description' => 'This is the default dashboard.',
                'layout'      => '24'
            ]);
        }

        $widgetRepository->create([
            'title' => 'Ads',
            'extension'   => 'visiosoft.extension.ads_widget',
            'dashboard'   => $dashboard->id,
            'pinned'   => true,
        ]);
    }
}