<?php namespace Visiosoft\AdsWidgetExtension\Command;

use Anomaly\ConfigurationModule\Configuration\Contract\ConfigurationRepositoryInterface;
use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use Illuminate\Contracts\Cache\Repository;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;


class LoadItems
{

    use DispatchesJobs;

    protected $widget;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
    }

    public function handle()
    {
        $my_advs = new AdvModel();
        $my_advs_pending = $my_advs->getAdv()
                                    ->where('advs_advs.status', '<>', 'approved')
                                    ->where('advs_advs.status', '<>', 'declined')
                                    ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'))
                                    ->orWhereNull('advs_advs.finish_at');
        $my_advs_pending = count($my_advs_pending->get());

        $my_advs_archived = $my_advs->getAdv()
                                    ->where('advs_advs.finish_at', '<', date('Y-m-d H:i:s'))
                                    ->WhereNotNull('advs_advs.finish_at');
        $my_advs_archived = count($my_advs_archived->get());

        $my_advs_approve = $my_advs->getAdv()
                                    ->where('advs_advs.status', 'approved')
                                    ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'));
        $my_advs_approve = count($my_advs_approve->get());

        $this->widget->addData('approve', $my_advs_approve)
                     ->addData('pending', $my_advs_pending)
                     ->addData('archived', $my_advs_archived);
    }
}
