<?php namespace Visiosoft\AdsWidgetExtension\Command;

use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\AdvsModule\Adv\AdvModel;


class LoadItems
{

    use DispatchesJobs;

    protected $widget;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
    }

    public function handle()
    {
        $myAdvs = new AdvModel();

        $myAdvsApprove = $myAdvs
            ->getAdv()
            ->where('advs_advs.status', 'approved')
            ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'));
        $myAdvsApprove = count($myAdvsApprove->get());

        $myAdvsPending = $myAdvs
            ->getAdv()
            ->where('advs_advs.status', 'pending_admin')
            ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'))
            ->orWhereNull('advs_advs.finish_at');
        $myAdvsPending = count($myAdvsPending->get());

        $myAdvsOutdated = $myAdvs
            ->getAdv()
            ->where('advs_advs.finish_at', '<', date('Y-m-d H:i:s'))
            ->WhereNotNull('advs_advs.finish_at');
        $myAdvsOutdated = count($myAdvsOutdated->get());

        $myAdvsPassive = $myAdvs
            ->getAdv()
            ->where('advs_advs.status', 'passive');
        $myAdvsPassive = count($myAdvsPassive->get());

        if (is_module_installed('visiosoft.module.dopings')) {
            $myAdvsPendingDoping = app('Visiosoft\DopingsModule\Http\Controller\DopingsController')->getPendingDopingCount();
            $this->widget->addData('pending_doping', $myAdvsPendingDoping);
        }

        if (is_module_installed('visiosoft.module.store')) {
            $storesCount = app('Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface')->getStoresCount();
            $this->widget->addData('stores_count', $storesCount);
        }

        if (is_module_installed('visiosoft.module.references')) {
            $referencesCount = app('Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface')->countReferences();
            $this->widget->addData('references_count', $referencesCount);
        }

        $this->widget
            ->addData('approve', $myAdvsApprove)
            ->addData('pending', $myAdvsPending)
            ->addData('outdated', $myAdvsOutdated)
            ->addData('passive', $myAdvsPassive);
    }
}
