<?php namespace Visiosoft\AdsChartWidgetExtension;

use Anomaly\DashboardModule\Dashboard\Contract\DashboardRepositoryInterface;
use Anomaly\DashboardModule\Widget\Contract\WidgetRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Dashboard\DashboardWidgetsEntryTranslationsModel;

class AdsChartWidgetExtensionSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(
        WidgetRepositoryInterface $widgetRepository,
        DashboardRepositoryInterface $dashboardRepository,
        DashboardWidgetsEntryTranslationsModel $widgetsEntryTranslationsModel
    )
    {
        $adsChartWidget = $widgetRepository->findBy('extension', 'visiosoft.extension.ads_chart_widget');
        if ($adsChartWidget) {
            $widgetsEntryTranslationsModel->newQuery()->where('entry_id', $adsChartWidget->id)->delete();
            $adsChartWidget->forceDelete();
        }

        $dashboard = $dashboardRepository->findBy('slug', 'welcome');
        if (is_null($dashboard)) {
            $dashboard = $dashboardRepository->create([
                'name' => 'Welcome',
                'slug' => 'welcome',
                'description' => 'This is the default dashboard.',
                'layout'      => '24'
            ]);
        }

        $widgetRepository->create([
            'title' => 'Ads Chart',
            'extension'   => 'visiosoft.extension.ads_chart_widget',
            'dashboard'   => $dashboard->id,
            'pinned'   => true,
        ]);
    }
}