<?php namespace Visiosoft\AdsChartWidgetExtension\Command;

use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use Carbon\Carbon;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\DB;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class LoadItems
{

    use DispatchesJobs;

    protected $widget;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
    }

    public function handle(AdvRepositoryInterface $advRepository)
    {
        $numberOfDays = setting_value('visiosoft.extension.ads_chart_widget::for_the_past_days');

        $adsCount = $advRepository
            ->newQuery()
            ->select([
                DB::raw('DATE(created_at) AS date'),
                DB::raw('COUNT(id) AS count'),
            ])
            ->whereBetween('created_at', [Carbon::now()->subDays((int)$numberOfDays), Carbon::now()])
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->get();

        $adCountArray = array();
        foreach ($adsCount as $adCount) {
            $adCountArray[$adCount->date] = $adCount->count;
        }

        $allDaysCount = array();
        $date = new Carbon;
        for ($i = 0; $i < $numberOfDays; $i++) {
            $dateString = $date->format('Y-m-d');
            if (!isset($adCountArray[$dateString])) {
                $allDaysCount[$dateString] = 0;
            } else {
                $allDaysCount[$dateString] = $adCountArray[$dateString];
            }
            $date->subDay();
        }

        $chartData = array();
        foreach ($allDaysCount as $date => $count) {
            $chartData[] = [$date, $count];
        }

        $this->widget->addData('chartData', $chartData);
    }
}
