<?php namespace Visiosoft\AddonsModule\Repository;

use Visiosoft\AddonsModule\Repository\RepositoryRepository;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;

/**
 * Class RepositorySeeder
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class RepositorySeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        /* @var RepositoryRepository $repositories */
        $repositories = app(RepositoryRepository::class);

        if (!$repositories->findBy('slug', 'repo')) {
            $repositories->create(
                [
                    'url'  => 'https://repo.openclassify.com',
                    'slug' => 'repo',
                    'en'   => [
                        'name'        => 'Repo Addons',
                        'description' => 'First-party addons from the makers of Openclassify.',
                    ],
                ]
            );
        }
    }
}
