<?php namespace Visiosoft\AddonsModule\Http\Controller\Admin;

use Visiosoft\AddonsModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\AddonsModule\Trial\Contract\TrialRepositoryInterface;
use Visiosoft\AddonsModule\Trial\Form\TrialFormBuilder;
use Visiosoft\AddonsModule\Trial\Table\TrialTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class TrialController extends AdminController
{
    protected $trialRepository;

    public function __construct(TrialRepositoryInterface $trialRepository)
    {
        parent::__construct();
        $this->trialRepository = $trialRepository;
    }

    public function index(TrialTableBuilder $table)
    {
        return $table->render();
    }

    public function create(TrialFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(TrialFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function trial(AddonRepositoryInterface $addonRepository, $addon)
    {
        try {
            $addon = $addonRepository->findByNamespace($addon);

            $addonName = ltrim($addon->name, 'visiosoft/');

            $subDomain = explode('.', config('app.application_domain'));
            $subDomain = isset($subDomain[0]) && $subDomain[0] ? $subDomain[0] : '';

            $redirectURL = route('visiosoft.module.addons::admin.addons.try.response', [
                'status' => ':status:',
                'msg' => ':msg:',
            ]);

            $triedBefore = $addon->triedBefore();
            if ($triedBefore) {
                throw new \Exception(trans('visiosoft.module.addons::message.you_tried_this_addon_before'));
            }

            $addon->try();

            return redirect(
                setting_value('visiosoft.module.addons::trial_url')
                .
                "/$subDomain/$addonName/"
                .
                encrypt($redirectURL)
            );
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return back();
        }
    }
}
