<?php namespace Visiosoft\AddonsModule\Trial;

use Carbon\Carbon;
use Visiosoft\AddonsModule\Trial\Contract\TrialRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TrialRepository extends EntryRepository implements TrialRepositoryInterface
{
    protected $model;

    public function __construct(TrialModel $model)
    {
        $this->model = $model;
    }

    public function getExpiredTrials()
    {
        return $this->getModel()
            ->where('expires_at', '<', Carbon::now())
            ->where('removed', false)
            ->get();
    }
}
