<?php namespace Visiosoft\AddonsModule\Http\Controller;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Anomaly\Streams\Platform\Addon\Extension\ExtensionManager;
use Anomaly\Streams\Platform\Addon\Module\Module;
use Anomaly\Streams\Platform\Addon\Module\ModuleManager;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AddonsModule\Trial\Contract\TrialRepositoryInterface;

class TrialController extends PublicController
{
    public function trialRemove(
        TrialRepositoryInterface $trialRepository,
        AddonCollection $addons,
        ModuleManager $modules,
        ExtensionManager $extensions
    )
    {
        try {
            $expiredTrials = $trialRepository->getExpiredTrials();

            foreach ($expiredTrials as $trial) {
                $addon = $addons->get($trial->addon->namespace);

                if ($addon instanceof Module) {
                    $modules->disable($addon);
                } elseif ($addon instanceof Extension) {
                    $extensions->disable($addon);
                }

                $trial->remove();
            }

            return [
                'success' => true,
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }
}
