<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleAddonsCreateTrialStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'trial',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'addon' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\AddonsModule\Addon\AddonModel::class,
            ]
        ],
        "expires_at" => 'anomaly.field_type.datetime',
        'removed' => 'anomaly.field_type.boolean',
    ];

    protected $assignments = [
        'addon' => [
            'required' => true,
        ],
        'expires_at' => [
            'required' => true,
        ],
        'removed',
    ];
}
