<?php namespace Visiosoft\AddonsModule;

use Visiosoft\AddonsModule\Addon\AddonRepository;
use Visiosoft\AddonsModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\AddonsModule\Composer\ComposerAuthorizer;
use Visiosoft\AddonsModule\Console\Download;
use Visiosoft\AddonsModule\Console\Remove;
use Visiosoft\AddonsModule\Console\Show;
use Visiosoft\AddonsModule\Console\Sync;
use Visiosoft\AddonsModule\Console\Update;
use Visiosoft\AddonsModule\Listener\RefreshAddonsModule;
use Visiosoft\AddonsModule\Repository\Contract\RepositoryRepositoryInterface;
use Visiosoft\AddonsModule\Repository\RepositoryRepository;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Application\Event\SystemIsRefreshing;

/**
 * Class AddonsModuleServiceProvider
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class AddonsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon commands.
     *
     * @var array
     */
    protected $commands = [
        Show::class,
        Sync::class,
        Remove::class,
        Update::class,
        Download::class,
    ];

    /**
     * The addon plugins.
     *
     * @var array
     */
    protected $plugins = [
        AddonsModulePlugin::class,
    ];

    /**
     * The addon listeners.
     *
     * @var array
     */
    protected $listeners = [
        SystemIsRefreshing::class => [
            RefreshAddonsModule::class,
        ],
    ];

    /**
     * The addon singletons.
     *
     * @var array
     */
    protected $singletons = [
        AddonRepositoryInterface::class      => AddonRepository::class,
        ComposerAuthorizer::class            => ComposerAuthorizer::class,
        RepositoryRepositoryInterface::class => RepositoryRepository::class,
    ];

    /**
     * The addon routes.
     *
     * @var array
     */
    protected $routes = [
        'admin/addons/enable/{addon}'    => [
            'as'   => 'visiosoft.module.addons::addons.enable',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@enable',
        ],
        'admin/addons/disable/{addon}'   => [
            'as'   => 'visiosoft.module.addons::addons.disable',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@disable',
        ],
        'admin/addons/install/{addon}'   => [
            'as'   => 'visiosoft.module.addons::addons.install',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@install',
        ],
        'admin/addons/uninstall/{addon}' => [
            'as'   => 'visiosoft.module.addons::addons.uninstall',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@uninstall',
        ],
        'admin/addons/migrate/{addon}'   => [
            'as'   => 'visiosoft.module.addons::addons.migrate',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@migrate',
        ],
        'admin/addons/view/{addon}'      => [
            'as'   => 'visiosoft.module.addons::addons.view',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@view',
        ],
        'admin/addons/remove/{addon}'    => [
            'as'   => 'visiosoft.module.addons::composer.remove',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@remove',
        ],
        'admin/addons/update/{addon}'    => [
            'as'   => 'visiosoft.module.addons::composer.update',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@update',
        ],
        'admin/addons/download/{addon}'  => [
            'as'   => 'visiosoft.module.addons::composer.download',
            'uses' => 'Visiosoft\AddonsModule\Http\Controller\Admin\AddonsController@download',
        ],
    ];

}
