<?php namespace Visiosoft\AddonsModule\Addon\Table;

use Visiosoft\AddonsModule\Addon\Contract\AddonInterface;
use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Anomaly\Streams\Platform\Addon\Module\Module;

/**
 * Class AddonTableButtons
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class AddonTableButtons
{

    /**
     * Handle the buttons.
     *
     * @param AddonTableBuilder $builder
     */
    public function handle(AddonTableBuilder $builder)
    {
        $builder->setButtons(
            [
                'view' => [
                    'href' => '/{request.path}/view/{entry.namespace}',
                ],
            ]
        );

        $builder->addbuttons(
            [
                'try'   => [
                    'href'    => function (AddonInterface $entry) {
                        $addonName = ltrim($entry->name, 'visiosoft/');

                        $subDomain = explode('.', config('app.application_domain'));
                        $subDomain = isset($subDomain[0]) && $subDomain[0] ? $subDomain[0] : '';

                        $redirectURL = route('visiosoft.module.addons::admin.addons.try.response', [
                            'status' => ':status:',
                            'msg' => ':msg:',
                        ]);

                        return setting_value('visiosoft.module.addons::trial_url') . "/$subDomain/$addonName/" . encrypt($redirectURL);
                    },
                    'type'   => 'warning',
                    'icon'   => 'fa fa-clock-o',
                    'enabled' => function () {
                        $isOcify = explode('.', config('app.application_domain'));
                        $isOcify = isset($isOcify[1]) && $isOcify[1] === 'ocify';

                        return !!setting_value('visiosoft.module.addons::trial_url') && $isOcify;
                    },
                ],
//                'install'   => [
//                    'href'         => 'admin/addons/install/{entry.namespace}',
//                    'data-message' => function (AddonInterface $entry) {
//                        return trans('visiosoft.module.addons::message.installing', ['addon' => $entry->getName()]);
//                    },
//                    'class'        => 'btn btn-success',
//                    'data-toggle'  => 'prompts',
//                    'enabled'      => function (AddonInterface $entry) {
//
//                        if (!in_array($entry->getType(), ['module', 'extension'])) {
//                            return false;
//                        }
//
//                        /* @var Module|Extension $addon */
//                        if (!$addon = $entry->instance()) {
//                            return false;
//                        }
//
//                        return !$addon->isInstalled();
//                    },
//                ],
                'uninstall' => [
                    'button'       => 'uninstall',
                    'data-match'   => 'entry.name',
                    'icon'         => 'times-circle',
                    'permission'   => 'visiosoft.module.addons::{entry.type}.manage',
                    'href'         => 'admin/addons/uninstall/{entry.namespace}',
                    'text'         => 'visiosoft.module.addons::button.uninstall',
                    'data-title'   => 'visiosoft.module.addons::confirm.uninstall_title',
                    'data-message' => 'visiosoft.module.addons::confirm.uninstall_message',
                    'enabled'      => function (AddonInterface $entry) {

                        if (!in_array($entry->getType(), ['module', 'extension'])) {
                            return false;
                        }

                        /* @var Module|Extension $addon */
                        if (!$addon = $entry->instance()) {
                            return false;
                        }

                        return $addon->isInstalled();
                    },
                ],
//                'enable'    => [
//                    'type'       => 'success',
//                    'icon'       => 'fa fa-toggle-on',
//                    'permission' => 'visiosoft.module.addons::{entry.type}.manage',
//                    'href'       => 'admin/addons/enable/{entry.namespace}',
//                    'enabled'    => function (AddonInterface $entry) {
//
//                        if (!in_array($entry->getType(), ['module', 'extension'])) {
//                            return false;
//                        }
//
//                        /* @var Module|Extension $addon */
//                        if (!$addon = $entry->instance()) {
//                            return false;
//                        }
//
//                        if (!$addon->isInstalled()) {
//                            return false;
//                        }
//
//                        return !$addon->isEnabled();
//                    },
//                ],
                'disable'   => [
                    'type'         => 'warning',
                    'data-icon'    => 'warning',
                    'data-toggle'  => 'confirm',
                    'icon'         => 'fa fa-toggle-off',
                    'text'         => 'visiosoft.module.addons::button.disable',
                    'permission'   => 'visiosoft.module.addons::{entry.type}.manage',
                    'href'         => 'admin/addons/disable/{entry.namespace}',
                    'data-title'   => 'visiosoft.module.addons::confirm.disable_title',
                    'data-message' => 'visiosoft.module.addons::confirm.disable_message',
                    'enabled'      => function (AddonInterface $entry) {

                        if (!in_array($entry->getType(), ['module', 'extension'])) {
                            return false;
                        }

                        /* @var Module|Extension $addon */
                        if (!$addon = $entry->instance()) {
                            return false;
                        }

                        if (!$addon->isInstalled()) {
                            return false;
                        }

                        return $addon->isEnabled();
                    },
                ],
            ]
        );
    }
}
