<?php namespace Anomaly\UsersModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\ActivateWithPhone;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ApiController extends ResourceController
{
    public function registerPhone(UserRepositoryInterface $userRepository, RoleRepositoryInterface $roleRepository)
    {
        $validator = Validator::make(request()->all(), [
            'phone' => 'required|max:15',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        try {

            $user_role = $roleRepository->findBySlug('user');

            if (!$user = $userRepository->findBy('phone', $this->request->phone)) {

                $create_parameters = [
                    'phone' => $this->request->phone,
                    'created_at' => Carbon::now(),
                    'str_id' => str_random(24),
                    'activation_code' => rand(100000, 999999),
                    'activated' => true,
                    'enabled' => true
                ];

                $user_id = DB::table('users_users')->insertGetId($create_parameters);

                $user = $userRepository->newQuery()->find($user_id);

                $user->roles()->sync([$user_role->getId()]);

            } else {
                $user->setAttribute('activation_code', rand(100000, 999999));
                $user->save();
            }

            event(new ActivateWithPhone($user));

            return [
                'success' => true,
                'message' => trans('anomaly.module.users::message.pending_phone_activation'),
                'code' => $user->activation_code
            ];

        } catch (\Exception $e) {
            return $this->response->json(['success' => false, 'message' => $e->getMessage()], 400);
        }
    }

    public function activatePhone(UserRepositoryInterface $userRepository)
    {
        $validator = Validator::make(request()->all(), [
            'code' => 'required|max:6',
            'phone' => 'required|max:15',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        $user = $userRepository->newQuery()
            ->where('activation_code', $this->request->code)
            ->where('phone', $this->request->phone)
            ->first();

        if (!$user) {
            return $this->response->json(['success' => false, 'message' => trans('anomaly.module.users::message.error_activation_code')], 400);
        }

        $user->setAttribute('activation_code', null);
        $user->save();

        $u_id = $user->id;
        $response = ['id' => $user->getId()];
        $response['token'] = app(\Visiosoft\ConnectModule\User\UserModel::class)->find($u_id)->createToken($u_id)->accessToken;

        return $this->response->json($response);
    }
}
