---
title: Middleware
---

### Middleware

This section will introduce you to the middleware services and how to use them.

#### Authorizing Routes

The Users module load's middleware into the stack that allows you to set custom parameters that ensure the request is made by an authorized user.

##### Authorize By Role

You can authorize a route with `\Anomaly\UsersModule\Http\Middleware\AuthorizeRouteRole` by defining the `anomaly.module.users::role` route parameter;

    'example/test' => [
        'anomaly.module.users::role' => 'my_role',
        'uses' => 'Example/Controller@test'
    ]

You can also define an array of roles where the user must have at least one:

    'example/test' => [
        'anomaly.module.users::role' => ['my_role', 'another_role'],
        'uses' => 'Example/Controller@test'
    ]

Additionally you may include an optional redirect path and message in case the user does not pass authorization:

    'example/test' => [
        'anomaly.module.users::role' => 'my_role',
        'anomaly.module.users::redirect' => '/',
        'anomaly.module.users::message' => 'Sorry, you do not have access.',
        'uses' => 'Example/Controller@test'
    ]

You can also directly use a route for the redirection:

    'example/test' => [
        'anomaly.module.users::role' => 'my_role',
        'anomaly.module.users::route' => 'vendor.module.example::route.name',
        'anomaly.module.users::message' => 'Sorry, you do not have access.',
        'uses' => 'Example/Controller@test'
    ]

##### Authorize By Permission

You can authorize a route with `\Anomaly\UsersModule\Http\Middleware\AuthorizeRoutePermission` by defining the `anomaly.module.users::permission` route parameter;

    'example/test' => [
        'anomaly.module.users::permission' => 'vendor.module.example::widgets.test',
        'uses' => 'Example/Controller@test'
    ]

You can also define an array of permissions where the user must have at least one:

    'example/test' => [
        'anomaly.module.users::role' => ['vendor.module.example::widgets.test', 'vendor.module.example::widgets.example'],
        'uses' => 'Example/Controller@test'
    ]

Additionally you may include an optional redirect path and message in case the user does not pass authorization:

    'example/test' => [
        'anomaly.module.users::permission' => 'vendor.module.example::widgets.test',
        'anomaly.module.users::redirect' => '/',
        'anomaly.module.users::message' => 'Sorry, you do not have access.',
        'uses' => 'Example/Controller@test'
    ]
    
You can also directly use a route for the redirection:

    'example/test' => [
        'anomaly.module.users::role' => 'vendor.module.example::widgets.test',
        'anomaly.module.users::route' => 'vendor.module.example::route.name',
        'anomaly.module.users::message' => 'Sorry, you do not have access.',
        'uses' => 'Example/Controller@test'
    ]
