### Authentication

This section will introduce you to the authentication service and how to user it.

#### User Authenticator

This class will go over the `\Anomaly\UsersModule\User\UserAuthenticator` class and how to use it.

##### UserAuthenticator::attempt()

The `attempt` method attempts to authorize a user. The `login` method is ran if the authentication succeeds.

###### Returns: `\Anomaly\UsersModule\User\Contract\UserInterface` or `false`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$credentials

</td>

<td>

true

</td>

<td>

array

</td>

<td>

none

</td>

<td>

The credentials array of email/username and password.

</td>

</tr>

<tr>

<td>

$remember

</td>

<td>

false

</td>

<td>

boolean

</td>

<td>

false

</td>

<td>

The "remember me" flag.

</td>

</tr>

</tbody>

</table>

###### Example

    $authenticator->attempt(['email' => 'example@domain.com', 'password' => 'secret']);

##### UserAuthenticator::authenticate()

The `authenticate` method authenticates credentials without logging the user in.

###### Returns: `\Anomaly\UsersModule\User\Contract\UserInterface` or `false`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$credentials

</td>

<td>

true

</td>

<td>

array

</td>

<td>

none

</td>

<td>

The credentials array of email/username and password.

</td>

</tr>

</tbody>

</table>

###### Example

    $authenticator->authenticate(['email' => 'example@domain.com', 'password' => 'secret password']);

##### UserAuthenticator::login()

The `login` method logs in the user.

###### Returns: `void`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$user

</td>

<td>

true

</td>

<td>

object

</td>

<td>

none

</td>

<td>

The user instance.

</td>

</tr>

</tbody>

</table>

###### Example

    $authenticator->login($user);

##### UserAuthenticator::logout()

The `logout` method logs out the user.

###### Returns: `void`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$user

</td>

<td>

true

</td>

<td>

object

</td>

<td>

none

</td>

<td>

The user to logout.

</td>

</tr>

</tbody>

</table>

###### Example

    $authenticator->logout($user);

##### UserAuthenticator::kickOut()

The `kickOut` method kicks a user. The `kickOut` method is similar to `logout` but a different event is fired for you to hook into as needed.

###### Returns: `void`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$user

</td>

<td>

true

</td>

<td>

object

</td>

<td>

none

</td>

<td>

The user to kick out.

</td>

</tr>

</tbody>

</table>

###### Example

    $authenticator->kickOut($user);

