---
title: Plugin
---

### Plugin

This section will go over how to use the plugin that comes with the Users module.

#### user

The `user` function returns a decorated user instance from the identifier provided.

###### Returns: `\Anomaly\UsersModule\User\UserPresenter` or `null`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$identifier

</td>

<td>

false

</td>

<td>

mixed

</td>

<td>

Will return the active user.

</td>

<td>

The id, email, or username of the user to return.

</td>

</tr>

</tbody>

</table>

###### Twig

    Hello {{ user().display_name }}

    Sup {{ user('ryanthepyro').first_name }}

#### role

The `role` method returns a decorated role instance from the identifier provided.

###### Returns: `\Anomaly\UsersModule\Role\RolePresenter` or `null`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$identifier

</td>

<td>

true

</td>

<td>

mixed

</td>

<td>

none

</td>

<td>

The ID or slug of the role to return.

</td>

</tr>

</tbody>

</table>

###### Example

    {% if role('user').hasPermission('example.module.test::example.test') %}
        {# Do something #}
    {% endif %}
