---
title: Roles
---

### Roles

Roles are groups of users that define what the users has access to via role `permissions`. Roles can also be used as an inclusive test like i.e. "Does this user have the `foo` role?".

#### Role Fields

Below is a list of `fields` in the `roles` stream. Fields are accessed as attributes:

    $role->slug;

Same goes for decorated instances in Twig:

    {{ role.slug }}

###### Fields

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Type</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

name

</td>

<td>

text

</td>

<td>

The name of the role.

</td>

</tr>

<tr>

<td>

slug

</td>

<td>

slug

</td>

<td>

The slug used for API access.

</td>

</tr>

<tr>

<td>

description

</td>

<td>

textarea

</td>

<td>

A description for the role.

</td>

</tr>

<tr>

<td>

permissions

</td>

<td>

textarea

</td>

<td>

A serialized array of role permissions.

</td>

</tr>

</tbody>

</table>

#### Role Interface

This section will go over the features of the `\Anomaly\UsersModule\Role\Contract\RoleInterface` class.

##### RoleInterface::hasPermission()

The `hasPermission` method verifies that the role has the `permission`.

###### Returns: `boolean`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$permission

</td>

<td>

true

</td>

<td>

string

</td>

<td>

none

</td>

<td>

The permission string.

</td>

</tr>

</tbody>

</table>

###### Example

    if ($role->hasPermission('vendor.module.example::example.test')) {
        // Do something
    }

###### Twig

    {% if role.hasPermission('vendor.module.example::example.test') %}
        {# Do something #}
    {% endif %}

##### RoleInterface::hasAnyPermission()

The `hasAnyPermission` method verifies that the role has at least one of the given permissions.

###### Returns: `boolean`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$permissions

</td>

<td>

true

</td>

<td>

array

</td>

<td>

none

</td>

<td>

The array of permissions.

</td>

</tr>

</tbody>

</table>

###### Example

    $hasPermission = $role->hasAnyPermission(
        ['vendor.module.example::example.test', 'vendor.module.example::widget.example']
    );

    if ($hasPermission) {
        // Do something
    }

###### Twig

    {% set hasPermission = role.hasAnyPermission(
        ['vendor.module.example::example.test', 'vendor.module.example::widget.example']
    ) %}

    {% if hasPermission %}
        {# Do something #}
    {% endif %}

#### Role Repository

The `\Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface` class helps you retrieve roles from the database.

##### RoleRepositoryInterface::allButAdmin()

The `allButAdmin` method returns all roles but the `admin` one.

###### Returns: `\Anomaly\UsersModule\Role\RoleCollection`

###### Example

    $roles = $repository->allButAdmin();

##### RoleRepositoryInterface::findBySlug()

The `findBySlug` method returns a role by it's slug.

###### Returns: `\Anomaly\UsersModule\Role\Contract\RoleInterface` or `null`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$slug

</td>

<td>

true

</td>

<td>

string

</td>

<td>

none

</td>

<td>

The slug of the role.

</td>

</tr>

</tbody>

</table>

###### Example

    $guest = $repository->findBySlug('guest');

##### RoleRepositoryInterface::findByPermission()

The `findByPermission` method returns all roles with the `permission`.

###### Returns: `\Anomaly\UsersModule\Role\RoleCollection`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$permission

</td>

<td>

true

</td>

<td>

string

</td>

<td>

none

</td>

<td>

The permission string.

</td>

</tr>

</tbody>

</table>

###### Example

    $roles = $repository->findByPermission('example.module.test::example.test');

    // Search for partial-match permissions.
    $roles = $repository->findByPermission('example.module.test::*');

##### RoleRepositoryInterface::updatePermissions()

The `updatePermissions` method updates the permissions for a role.

###### Returns: `\Anomaly\UsersModule\Role\Contract\RoleInterface`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$role

</td>

<td>

true

</td>

<td>

object

</td>

<td>

none

</td>

<td>

The role instance.

</td>

</tr>

<tr>

<td>

$permissions

</td>

<td>

true

</td>

<td>

array

</td>

<td>

none

</td>

<td>

The array of role permissions.

</td>

</tr>

</tbody>

</table>

###### Example

    $repository->updatePermissions(
        $role,
        [
            'example.module.test::example.test',
            'example.module.test::example.foo'
        ]
    );
