---
title: Configuration
---

### Configuration

You can override Users module configuration by publishing the addon and modifying the resulting configuration file:

    php artisan addon:publish anomaly.module.users

The addon will be published to `/resources/{application}/addons/anomaly/users-module`.

#### Login Field

The `anomaly.module.users::config.login` value determines which field is used for logging in along with the password. Valid options are `email` (default) or `username`.

    'login' => env('LOGIN', 'email'),

You can also use the `.env` file to set this value with `LOGIN`.

#### Activation Mode

The `anomaly.module.users::config.activation_mode` value determines how users are activated when they register. A user must be activated in order to login.

    'activation_mode' => env('ACTIVATION_MODE', 'email'),

Valid options are:

*   `email` - Send an activation email to the user. This is the default mode.
*   `manual` - Require an admin to manually activate the user.
*   `automatic` - Automatically activate the user when they register.
