<?php namespace Anomaly\UsersModule\SmsSeeder;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\SmsModule\Template\Command\SmsTemplateCreator;

class SmsSeeder extends Seeder
{
    use DispatchesJobs;

    public function run()
    {
        if (is_module_installed('visiosoft.module.sms')) {

            $templates = [
                [
                    'en' => [
                        'name' => 'Register Phone',
                        'message' => "You can login with your {code} activation code.",
                    ],
                    'slug' => Str::slug('Register Phone', '_'),
                    'isactive' => true
                ],
            ];

            foreach ($templates as $template) {
                $this->dispatch(new SmsTemplateCreator($template));
            }
        }
    }
}
