---
title: Users
---

### Users

Users are extensible stream entries that can be associated with multiples `roles`. Users have their own `permissions` that merge with those inherited from the `roles` they belong to.

#### User Fields

Below is a list of `fields` in the `users` stream. Fields are accessed as attributes:

    $user->email;

Same goes for decorated instances in Twig:

    {{ user.email }}

###### Fields

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Type</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

email

</td>

<td>

email

</td>

<td>

The login email address.

</td>

</tr>

<tr>

<td>

username

</td>

<td>

text

</td>

<td>

The login username.

</td>

</tr>

<tr>

<td>

password

</td>

<td>

text

</td>

<td>

The hashed login password.

</td>

</tr>

<tr>

<td>

roles

</td>

<td>

multiple relationship

</td>

<td>

The roles the user has.

</td>

</tr>

<tr>

<td>

display_name

</td>

<td>

text

</td>

<td>

The publicly displayable name.

</td>

</tr>

<tr>

<td>

first_name

</td>

<td>

text

</td>

<td>

The real first name.

</td>

</tr>

<tr>

<td>

last_name

</td>

<td>

text

</td>

<td>

The real last name.

</td>

</tr>

<tr>

<td>

permissions

</td>

<td>

textarea

</td>

<td>

The serialized user permission array.

</td>

</tr>

<tr>

<td>

last_login_at

</td>

<td>

datetime

</td>

<td>

The last login datetime.

</td>

</tr>

<tr>

<td>

last_activity_at

</td>

<td>

text

</td>

<td>

The datetime for the last action made by the user.

</td>

</tr>

<tr>

<td>

ip_address

</td>

<td>

text

</td>

<td>

The last IP address that accessed the user account.

</td>

</tr>

</tbody>

</table>

##### Custom User Fields

Custom user fields assigned through the control panel are assigned directly to the `users` stream and can be accessed directly from the user object.

    $user->favorite_color;

And in Twig:

    {{ user.favorite_color }}

#### User Interface

This section will go over the features of the `\Anomaly\UsersModule\User\Contract\UserInterface` class.

##### UserInterface::hasRole()

The `hasRole` method ensures that the user has the given `role`.

###### Returns: `boolean`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$role

</td>

<td>

true

</td>

<td>

string

</td>

<td>

none

</td>

<td>

The role ID, slug, or interface.

</td>

</tr>

</tbody>

</table>

###### Example

    if (auth()->user()->hasRole('admin')) {
        echo "User is an admin!";
    }

###### Twig

    {% if auth_user().hasRole('admin')) %}
        User is an admin!
    {% endif %}

##### UserInterface::hasAnyRole()

The `hasAnyRole` method ensures that the user has at least one of the provided roles.

###### Returns: `boolean`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$roles

</td>

<td>

true

</td>

<td>

mixed

</td>

<td>

none

</td>

<td>

An array of role IDs or slugs. A collection of roles can also be passed.

</td>

</tr>

</tbody>

</table>

###### Example

    if (auth()->user()->hasAnyRole(['admin', 'manager'])) {
        echo 'Hello ' . $user->display_name;
    }

###### Twig

    {% if auth().user().hasAnyRole(['admin', 'manager'])) %}
        Hello {{ auth_user().display_name }}
    {% endif %}

##### UserInterface::isAdmin()

The `isAdmin` method returns if the user has the `admin` role or not.

###### Returns: `boolean`

###### Example

    if ($user->isAdmin()) {
        echo "Hi Admin.";
    }

###### Twig

    Hello {{ auth_user().isAdmin() ? 'admin' : 'user' }}

##### UserInterface::hasPermission()

The `hasPermission` method verifies that the user has the `permission`.

###### Returns: `boolean`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$permission

</td>

<td>

true

</td>

<td>

string

</td>

<td>

none

</td>

<td>

The permission string.

</td>

</tr>

<tr>

<td>

$checkRoles

</td>

<td>

false

</td>

<td>

boolean

</td>

<td>

true

</td>

<td>

Check the users roles for the permission too.

</td>

</tr>

</tbody>

</table>

###### Example

    if (auth()->user()->hasPermission('vendor.module.example::example.test')) {
        // So something
    }

###### Twig

    {% if auth_user().hasPermission('vendor.module.example::example.test')) %}
        {# So something #}
    {% endif %}

##### UserInterface::hasAnyPermission()

The `hasAnyPermission` method verifies that the user has at least one of the given permissions.

###### Returns: `boolean`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$permissions

</td>

<td>

true

</td>

<td>

array

</td>

<td>

none

</td>

<td>

The array of permissions.

</td>

</tr>

<tr>

<td>

$checkRoles

</td>

<td>

false

</td>

<td>

boolean

</td>

<td>

true

</td>

<td>

Check the users roles for the permission too.

</td>

</tr>

</tbody>

</table>

###### Example

    $hasPermission = auth()->user()->hasAnyPermission(
        ['vendor.module.example::example.test', 'vendor.module.example::widget.example']
    );

    if ($hasPermission) {
        // Do something
    }

###### Twig

    {% set hasPermission = auth_user().hasAnyPermission(
        ['vendor.module.example::example.test', 'vendor.module.example::widget.example']
    ) %}

    {% if hasPermission %}
        {# Do something #}
    {% endif %}

#### User Presenter

This section will go over the `\Anomaly\UsersModule\User\UserPresenter` class that's returned in the view layer.

##### UserPresenter::name()

The `name` method returns the concatenated first and last name.

###### Returns: `string`

###### Example

    $decorated->name();

###### Twig

    Hi {{ user().name() }}

##### UserPresenter::gravatar()

The `gravatar` method returns a Gravatar image URL for the user.

###### Returns: `string`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$parameters

</td>

<td>

true

</td>

<td>

array

</td>

<td>

none

</td>

<td>

Gravatar URL parameters.

</td>

</tr>

</tbody>

</table>

###### Example

    $decorated->avatar(['d' => 'mm']);

###### Twig

    {{ img(user().gravatar({'d': 'mm'})).class('img-rounded')|raw }}

#### User Repository

The `\Anomaly\UsersModule\User\Contract\UserRepositoryInterface` class helps you retrieve users from the database.

##### UserRepositoryInterface::findByEmail()

The `findByEmail` method finds a user by their email.

###### Returns: `\Anomaly\UsersModule\User\Contract\UserInterface` or `null`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$email

</td>

<td>

true

</td>

<td>

string

</td>

<td>

none

</td>

<td>

The users email.

</td>

</tr>

</tbody>

</table>

###### Example

    $user = $repository->findByEmail('example@domain.com');

##### UserRepositoryInterface::findByUsername()

The `findByUsername` method finds a user by their username.

###### Returns: `\Anomaly\UsersModule\User\Contract\UserInterface` or `null`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$username

</td>

<td>

true

</td>

<td>

string

</td>

<td>

none

</td>

<td>

The username of the user.

</td>

</tr>

</tbody>

</table>

###### Example

    $user = $repository->findByUsername('ryanthepyro');

##### UserRepositoryInterface::findByCredentials()

The `findByCredentials` method finds a user by their login field and password.

###### Returns: `\Anomaly\UsersModule\User\Contract\UserInterface` or `null`

###### Arguments

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Default</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

$credentials

</td>

<td>

true

</td>

<td>

array

</td>

<td>

none

</td>

<td>

The credentials array containing email/username and password.

</td>

</tr>

</tbody>

</table>

###### Example

    $user = $repository->findByCredentials(['email' => 'example@domain.com', 'password' => 'secret password']);
