---
title: Change Log
---

# Change Log

<div class="documentation__toc"></div>

## Introduction

All notable changes to this project will be documented in this file.

- `Added` for new features.
- `Changed` for changes in existing functionality.
- `Deprecated` for soon-to-be removed features.
- `Removed` for now removed features.
- `Fixed` for any bug fixes.
- `Security` in case of vulnerabilities.

### Versioning

This project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

### Deprecated Features

Features that are deprecated will generally be removed in the next `minor` update unless noted otherwise.

## Releases


### [2.6.18] - 2022-08-01
#### Added
- Added `getSitemap` method to `PostRepository` for filtering `sitemap.xml` results.


### [2.6.17] - 2020-07-07
#### Fixed
- Fixed issue with disabled posts indexing.


### [2.6.16] - 2020-05-15
#### Added
- Added `POSTS_URL_BASE` support to control base URI segment.


### [2.6.15] - 2020-01-13
#### Added
- Added Turkish translation. 


### [2.6.14] - 2019-09-14
#### Fixed
- Fixed issue with restoring post types.


### [2.6.13] - 2019-09-06
#### Fixed
- Fixed issue where `\Anomaly\PostsModule\Post\Table\Filter\StatusFilterQuery` was extending a frivolous base filter that changed signature. 

#### Added
- Added Turkish translation.


### [2.6.12] - 2019-07-18
#### Fixed
- Fixed issue where `live` scope was assuming UTC database to compare `publish_at` to.


### [2.6.8] - 2019-05-17
#### Fixed
- Fixed issue where `live` scope was using a potentially non-UTC date to compare `publish_at` to.


### [2.6.7] - 2019-04-09
#### Change
- Forced setting `str_id` during `saving` to avoid conflicts with new clone feature.


### [2.6.6] - 2019-03-13
#### Added
- Added translatable page slugs.

#### Fixed
- Fixed issues around `config:cache` like closures and re-generating cache on pages save.
- Fixed issues around `route:cache` like closures and re-generating routes on pages save.

#### Changed
- Changed `composer.json` to include proper support links.
- Changed `composer.json` to use `"anomaly/streams-platform": "^1.6"`.
