<?php namespace Anomaly\ApiModule\Resource\Component\Result\Command;

use Anomaly\ApiModule\Resource\Component\Result\ResultBuilder;
use Anomaly\ApiModule\Resource\ResourceBuilder;


/**
 * Class BuildResults
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Result\Command
 */
class BuildResults
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new BuildResults instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param ResultBuilder $builder
     */
    public function handle(ResultBuilder $builder)
    {
        $builder->build($this->builder);
    }
}
