<?php namespace Anomaly\ApiModule\Resource\Component\Field;

use Anomaly\ApiModule\Resource\ResourceBuilder;
use Anomaly\Streams\Platform\Support\Resolver;

/**
 * Class FieldResolver
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\View
 */
class FieldResolver
{

    /**
     * The resolver utility.
     *
     * @var Resolver
     */
    protected $resolver;

    /**
     * Create a new FieldResolver instance.
     *
     * @param Resolver $resolver
     */
    public function __construct(Resolver $resolver)
    {
        $this->resolver = $resolver;
    }

    /**
     * Resolve resource views.
     *
     * @param ResourceBuilder $builder
     */
    public function resolve(ResourceBuilder $builder)
    {
        $this->resolver->resolve($builder->getFields(), compact('builder'));
    }
}
