<?php namespace Anomaly\ApiModule\Resource\Component\Field\Command\Handler;

use Anomaly\ApiModule\Resource\Component\Field\Command\GetFieldValue;
use Anomaly\ApiModule\Resource\Component\Field\FieldValue;

/**
 * Class GetFieldValueHandler
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Field\Command
 */
class GetFieldValueHandler
{

    /**
     * The value utility.
     *
     * @var \Anomaly\ApiModule\Resource\Component\Field\FieldValue
     */
    protected $value;

    /**
     * Create a new GetFieldValueHandler instance.
     *
     * @param FieldValue $value
     */
    public function __construct(FieldValue $value)
    {
        $this->value = $value;
    }

    /**
     * Handle the command.
     *
     * @param GetFieldValue $command
     * @return mixed
     */
    public function handle(GetFieldValue $command)
    {
        $entry    = $command->getEntry();
        $resource = $command->getResource();
        $field    = $command->getField();

        return $this->value->make($resource, $field, $entry);
    }
}
