<?php namespace Anomaly\Streams\Platform\Ui\Entity\Event;

use Anomaly\Streams\Platform\Ui\Entity\Entity;

/**
 * Class EntityWasSaved
 *
 * @link          http://anomaly.is/streams-platentity
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\Streams\Platform\Ui\Entity\Event
 */
class EntityWasSaved
{

    /**
     * The entity object.
     *
     * @var Entity
     */
    protected $entity;

    /**
     * Create a new EntityWasSaved instance.
     *
     * @param Entity $entity
     */
    public function __construct(Entity $entity)
    {
        $this->entity = $entity;
    }

    /**
     * Ge the entity.
     *
     * @return Entity
     */
    public function getEntity()
    {
        return $this->entity;
    }
}
