<?php namespace Anomaly\Streams\Platform\Ui\Entity;

use Illuminate\Support\Collection;

/**
 * Class EntityCollection
 *
 * @link          http://anomaly.is/streams-platentity
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\Streams\Platform\Ui\Entity
 */
class EntityCollection extends Collection
{

    /**
     * Put a entity into the entity collection.
     *
     * @param               $slug
     * @param EntityBuilder $entity
     * @return $this
     */
    public function add($slug, EntityBuilder $entity)
    {
        $this->put($slug, $entity);

        return $this;
    }
}
