<?php namespace Anomaly\ApiModule\Command;

use Anomaly\Streams\Platform\Application\Application;
use Symfony\Component\Process\Process;

/**
 * Class GenerateKeys
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class GenerateKeys
{

    /**
     * Handle the command.
     *
     * @param Application $application
     */
    public function handle(Application $application)
    {
        if (file_exists($application->getStoragePath('oauth-private.key'))) {
            return;
        }

        (new Process(
            'openssl genrsa -out oauth-private.key 4096',
            $application->getStoragePath()
        ))->run();

        (new Process(
            'openssl rsa -in oauth-private.key -pubout -out oauth-public.key',
            $application->getStoragePath()
        ))->run();
    }
}
