<?php namespace Anomaly\ApiModule\Client\Form;

use Anomaly\UsersModule\User\UserModel;

class ClientFormFields
{
    public function handle(ClientFormBuilder $builder)
    {
        $builder->setFields(
            [
                'user_id'  => [
                    'required'     => true,
                    'label'        => 'anomaly.module.api::field.user.name',
                    'instructions' => 'anomaly.module.api::field.user.instructions',
                    'type'         => 'anomaly.field_type.relationship',
                    'config'       => [
                        'mode'    => 'lookup',
                        'related' => UserModel::class,
                    ],
                ],
                'name'     => [
                    'required'     => true,
                    'label'        => 'anomaly.module.api::field.name.name',
                    'instructions' => 'anomaly.module.api::field.name.instructions',
                    'type'         => 'anomaly.field_type.text',
                ],
                'redirect' => [
                    'required'     => true,
                    'label'        => 'anomaly.module.api::field.redirect.name',
                    'instructions' => 'anomaly.module.api::field.redirect.instructions',
                    'type'         => 'anomaly.field_type.url',
                    'value' => url('/auth/callback'),
                ],
            ]
        );
    }
}
