<?php namespace Anomaly\ApiModule;

use Anomaly\ApiModule\Command\PurgeHttpCache;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Support\Observer;

/**
 * Class ApiModuleObserver
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ApiModuleObserver extends Observer
{

    /**
     * Fired just after saving.
     *
     * @param EntryInterface $entry
     */
    public function saved(EntryInterface $entry)
    {
        dispatch_now(new PurgeHttpCache($entry));
    }
}
