---
title: Formatters 
---

### Formatters

The `formatters` query string parameter is an array of `attribute` and `pattern` formatters.

Formatters are based on field type presenters and provide a simple dot notation syntax.

This section will show you how to decorate your returned data with `formatters`.

#### Decorating Existing Fields

To decorate an existing field simply provide a formatter named the same name as the field in the Stream entry.

For example to decorate the email field in Users with `EmailFieldType::mailto()` method you would specify a formatter like this:

    $http = new GuzzleHttp\Client;

    $response = $http->request(
        'GET',
        'http://yoursite.com/entries/users/users',
        [
            'query' => [
                'formatters' => [
                    'email' => 'entry.email.mailto'
                ]
            ],
            'headers' => [
                'Authorization'    => 'Bearer ' . $accessToken,
            ],
        ]
    );

    return json_decode((string)$response->getBody(), true);

The response would be formatted like this:

    {
      "data": [
        {
          "id": 1,
          "sort_order": 1,
          "created_at": "2017-02-25 12:40:06",
          "created_by_id": null,
          "updated_at": "2017-02-25 14:09:29",
          "updated_by_id": 1,
          "deleted_at": null,
          "email": "<a href=\"&#109;&#x61;&#x69;&#x6c;&#x74;&#111;&#58;&#x72;ya&#110;&#64;p&#x79;&#114;&#111;&#x63;&#109;s&#x2e;&#x63;om\">&#x72;ya&#110;&#64;p&#x79;&#114;&#111;&#x63;&#109;s&#x2e;&#x63;om</a>",
          "username": "admin",
          "display_name": "Administrator",
          "first_name": null,
          "last_name": null,
          "activated": 1,
          "enabled": 1,
          "permissions": null,
          "last_login_at": "2017-02-25 14:09:29",
          "remember_token": "AT5Y59ugouhS3RONVf3KgcxjBNoPG2CQKJTywyYQ31C1uNw7yKZJYIycPOsr",
          "activation_code": null,
          "reset_code": null,
          "last_activity_at": "2017-02-25 14:06:43",
          "ip_address": "::1"
        },
        {
          "id": 2,
          "sort_order": 2,
          "created_at": "2017-02-25 12:40:07",
          "created_by_id": null,
          "updated_at": "2017-02-25 12:40:07",
          "updated_by_id": null,
          "deleted_at": null,
          "email": "<a href=\"&#109;&#97;&#x69;&#108;&#x74;&#111;:&#x64;&#101;m&#x6f;&#x40;&#x70;y&#x72;o&#x63;&#109;&#115;&#46;&#99;&#x6f;&#x6d;\">&#x64;&#101;m&#x6f;&#x40;&#x70;y&#x72;o&#x63;&#109;&#115;&#46;&#99;&#x6f;&#x6d;</a>",
          "username": "demo",
          "display_name": "Demo User",
          "first_name": null,
          "last_name": null,
          "activated": 1,
          "enabled": 1,
          "permissions": null,
          "last_login_at": null,
          "remember_token": null,
          "activation_code": null,
          "reset_code": null,
          "last_activity_at": null,
          "ip_address": null
        }
      ],
      "pagination": {
        "total": 2,
        "per_page": 15,
        "current_page": 1,
        "last_page": 1,
        "next_page_url": null,
        "prev_page_url": null,
        "from": 1,
        "to": 2
      }
    }

#### Adding Additional Fields

Formatters can also be used to include "new fields" in the return data.

If we wanted to _include_ the `mailto` link but not replace the email attribute with it then we could define the formatter with a new name:

    $http = new GuzzleHttp\Client;

    $response = $http->request(
        'GET',
        'http://yoursite.com/entries/users/users',
        [
            'query' => [
                'formatters' => [
                    'mailto' => 'entry.email.mailto'
                ]
            ],
            'headers' => [
                'Authorization'    => 'Bearer ' . $accessToken,
            ],
        ]
    );

    return json_decode((string)$response->getBody(), true);

The response would be formatted like this:

    {
      "data": [
        {
          "id": 1,
          "sort_order": 1,
          "created_at": "2017-02-25 12:40:06",
          "created_by_id": null,
          "updated_at": "2017-02-25 14:09:29",
          "updated_by_id": 1,
          "deleted_at": null,
          "email": "ryan@pyrocms.com",
          "username": "admin",
          "display_name": "Administrator",
          "first_name": null,
          "last_name": null,
          "activated": 1,
          "enabled": 1,
          "permissions": null,
          "last_login_at": "2017-02-25 14:09:29",
          "remember_token": "AT5Y59ugouhS3RONVf3KgcxjBNoPG2CQKJTywyYQ31C1uNw7yKZJYIycPOsr",
          "activation_code": null,
          "reset_code": null,
          "last_activity_at": "2017-02-25 14:06:43",
          "ip_address": "::1",
          "mailto": "<a href=\"&#109;&#x61;&#x69;&#x6c;&#x74;&#111;&#58;&#x72;ya&#110;&#64;p&#x79;&#114;&#111;&#x63;&#109;s&#x2e;&#x63;om\">&#x72;ya&#110;&#64;p&#x79;&#114;&#111;&#x63;&#109;s&#x2e;&#x63;om</a>"
        },
        {
          "id": 2,
          "sort_order": 2,
          "created_at": "2017-02-25 12:40:07",
          "created_by_id": null,
          "updated_at": "2017-02-25 12:40:07",
          "updated_by_id": null,
          "deleted_at": null,
          "email": "demo@pyrocms.com",
          "username": "demo",
          "display_name": "Demo User",
          "first_name": null,
          "last_name": null,
          "activated": 1,
          "enabled": 1,
          "permissions": null,
          "last_login_at": null,
          "remember_token": null,
          "activation_code": null,
          "reset_code": null,
          "last_activity_at": null,
          "ip_address": null,
          "mailto": "<a href=\"&#109;&#97;&#x69;&#108;&#x74;&#111;:&#x64;&#101;m&#x6f;&#x40;&#x70;y&#x72;o&#x63;&#109;&#115;&#46;&#99;&#x6f;&#x6d;\">&#x64;&#101;m&#x6f;&#x40;&#x70;y&#x72;o&#x63;&#109;&#115;&#46;&#99;&#x6f;&#x6d;</a>"
        }
      ],
      "pagination": {
        "total": 2,
        "per_page": 15,
        "current_page": 1,
        "last_page": 1,
        "next_page_url": null,
        "prev_page_url": null,
        "from": 1,
        "to": 2
      }
    }

#### Including Related Entries

You can use formatters to include related entries in the same request:

    $response = $http->request(
        'GET',
        'http://workbench.local:8888/api/entries/users/users',
        [
            'query' => [
                'formatters' => [
                    'roles' => 'entry.roles'
                ]
            ],
            'headers' => [
                'Authorization'    => 'Bearer ' . $accessToken,
            ],
        ]
    );

    return json_decode((string)$response->getBody(), true);

The response data will include the collection of roles:

    {
      "data": [
        {
          "id": 1,
          "sort_order": 1,
          "created_at": "2017-02-25 12:40:06",
          "created_by_id": null,
          "updated_at": "2017-02-25 14:09:29",
          "updated_by_id": 1,
          "deleted_at": null,
          "email": "ryan@pyrocms.com",
          "username": "admin",
          "display_name": "Administrator",
          "first_name": null,
          "last_name": null,
          "activated": 1,
          "enabled": 1,
          "permissions": null,
          "last_login_at": "2017-02-25 14:09:29",
          "remember_token": "AT5Y59ugouhS3RONVf3KgcxjBNoPG2CQKJTywyYQ31C1uNw7yKZJYIycPOsr",
          "activation_code": null,
          "reset_code": null,
          "last_activity_at": "2017-02-25 14:06:43",
          "ip_address": "::1",
          "roles": {
            "admin": {
              "id": 1,
              "sort_order": 1,
              "created_at": "2017-02-25 12:40:06",
              "created_by_id": null,
              "updated_at": null,
              "updated_by_id": null,
              "deleted_at": null,
              "slug": "admin",
              "permissions": null,
              "name": "Admin",
              "description": "The super admin role."
            }
          }
        },
        {
          "id": 2,
          "sort_order": 2,
          "created_at": "2017-02-25 12:40:07",
          "created_by_id": null,
          "updated_at": "2017-02-25 12:40:07",
          "updated_by_id": null,
          "deleted_at": null,
          "email": "demo@pyrocms.com",
          "username": "demo",
          "display_name": "Demo User",
          "first_name": null,
          "last_name": null,
          "activated": 1,
          "enabled": 1,
          "permissions": null,
          "last_login_at": null,
          "remember_token": null,
          "activation_code": null,
          "reset_code": null,
          "last_activity_at": null,
          "ip_address": null,
          "roles": {
            "user": {
              "id": 2,
              "sort_order": 2,
              "created_at": "2017-02-25 12:40:06",
              "created_by_id": null,
              "updated_at": null,
              "updated_by_id": null,
              "deleted_at": null,
              "slug": "user",
              "permissions": null,
              "name": "User",
              "description": "The default user role."
            }
          }
        }
      ],
      "pagination": {
        "total": 2,
        "per_page": 15,
        "current_page": 1,
        "last_page": 1,
        "next_page_url": null,
        "prev_page_url": null,
        "from": 1,
        "to": 2
      }
    }
