---
title: API Routes 
---

### API Routes

This section will go over everything you need to know about API routes.

#### /api/entries/{namespace}/{stream}

The `entries` endpoint exposes Stream entries specified by the `namespace` and `stream` parameters.

###### Parameters

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Example</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

namespace

</td>

<td>

true

</td>

<td>

string

</td>

<td>

pages

</td>

<td>

The namespace of the Stream you want to access entries for.

</td>

</tr>

<tr>

<td>

stream

</td>

<td>

true

</td>

<td>

string

</td>

<td>

pages

</td>

<td>

The slug of the Stream you want to access entries for within the provided namespace.

</td>

</tr>

</tbody>

</table>

#### /api/entries/{namespace}/{stream}/{id}

The `entries` endpoint also exposes single Stream entries specified by the `namespace`, `stream`, and `id` parameters.

###### Parameters

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Required</th>

<th>Type</th>

<th>Example</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

namespace

</td>

<td>

true

</td>

<td>

string

</td>

<td>

pages

</td>

<td>

The namespace of the Stream you want to access entries for.

</td>

</tr>

<tr>

<td>

stream

</td>

<td>

true

</td>

<td>

string

</td>

<td>

pages

</td>

<td>

The slug of the Stream you want to access entries for within the provided namespace.

</td>

</tr>

<tr>

<td>

id

</td>

<td>

true

</td>

<td>

integer

</td>

<td>

10

</td>

<td>

The ID of the entry you want to access within the provided namespace and stream.

</td>

</tr>

</tbody>

</table>

#### Traversing Relationships

You can use a RESTful pattern to traverse entry relationships and format the results too:

For example to get the category for the post with ID 1:

    /api/entries/posts/posts/1/category

To get the user that created the above category:

    /api/entries/posts/posts/1/category/created_by

#### Defining API Routes

Defining custom API routes could not be easier. Let's take a look at a couple ways to handle this.

##### Addon Service Providers

You can define your API routes just like normal routes in the `protected $api = []` property of your addon service provider:

    protected $api = [
        'api/example-module/test' => 'Anomaly\ExampleModule\Http\Controller\Api\TestController@doSomething'
    ];

##### Laravel Router

You can also define routes the Laravel way using the `Router`. Just make sure to define the `auth:api` middleware:

    Router::get('api/example-module/test', 'Anomaly\ExampleModule\Http\Controller\Api\TestController@doSomething')
        ->middleware('auth:api');

##### The Resource Controller

Your API controllers should extend the base resource controller:

    <?php namespace Anomaly\ExampleModule\Http\Controller\Api;

    use Anomaly\Streams\Platform\Http\Controller\ResourceController;

    class TestController extends ResourceController
    {

    }
