<?php namespace Anomaly\ApiModule\Resource\Component\Formatter;

use Anomaly\ApiModule\Resource\ResourceBuilder;
use Anomaly\Streams\Platform\Support\Resolver;

/**
 * Class FormatterResolver
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\View
 */
class FormatterResolver
{

    /**
     * The resolver utility.
     *
     * @var Resolver
     */
    protected $resolver;

    /**
     * Create a new FormatterResolver instance.
     *
     * @param Resolver $resolver
     */
    public function __construct(Resolver $resolver)
    {
        $this->resolver = $resolver;
    }

    /**
     * Resolve resource views.
     *
     * @param ResourceBuilder $builder
     */
    public function resolve(ResourceBuilder $builder)
    {
        $this->resolver->resolve($builder->getFormatters(), compact('builder'));
    }
}
